/*
 * Decompiled with CFR 0.152.
 */
package charlie.terms.replaceable;

import charlie.terms.replaceable.ImmutableRenaming;
import charlie.terms.replaceable.Renaming;
import charlie.terms.replaceable.Replaceable;
import charlie.terms.replaceable.ReplaceableList;
import charlie.util.NullStorageException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class MutableRenaming
implements Renaming {
    private TreeMap<Replaceable, String> _repToName = new TreeMap();
    private TreeMap<String, Replaceable> _nameToRep = new TreeMap();
    private TreeSet<String> _avoid;

    public MutableRenaming(Set<String> blockedNames) {
        this._avoid = new TreeSet<String>(blockedNames);
    }

    public void avoid(String name) {
        this._avoid.add(name);
    }

    public boolean setName(Replaceable x, String name) {
        if (x == null || name == null) {
            throw new NullStorageException("Renaming", "replaceable or name");
        }
        if (this._avoid.contains(name)) {
            return false;
        }
        Replaceable y = this._nameToRep.get(name);
        if (y != null && y != x) {
            return false;
        }
        String origName = this._repToName.get(x);
        if (origName != null) {
            this._nameToRep.remove(origName);
        }
        this._repToName.put(x, name);
        this._nameToRep.put(name, x);
        return true;
    }

    public void unsetName(Replaceable x) {
        String name = this._repToName.get(x);
        if (name == null) {
            return;
        }
        this._repToName.remove(x);
        this._nameToRep.remove(name);
    }

    @Override
    public String getName(Replaceable x) {
        return this._repToName.get(x);
    }

    @Override
    public Replaceable getReplaceable(String name) {
        return this._nameToRep.get(name);
    }

    @Override
    public Set<Replaceable> domain() {
        return this._repToName.keySet();
    }

    @Override
    public Set<String> range() {
        return this._nameToRep.keySet();
    }

    public boolean isAvailable(String name) {
        return !this._avoid.contains(name) && this._nameToRep.get(name) == null;
    }

    @Override
    public MutableRenaming copy() {
        MutableRenaming ret = new MutableRenaming(this._avoid);
        ret._repToName.putAll(this._repToName);
        ret._nameToRep.putAll(this._nameToRep);
        return ret;
    }

    @Override
    public Renaming makeImmutable() {
        return new ImmutableRenaming(this);
    }

    public void limitDomain(ReplaceableList ... lists) {
        TreeSet<Replaceable> remove = new TreeSet<Replaceable>();
        for (Replaceable r : this._repToName.keySet()) {
            boolean ok = false;
            for (ReplaceableList l : lists) {
                if (!l.contains(r)) continue;
                ok = true;
                break;
            }
            if (ok) continue;
            remove.add(r);
        }
        for (Replaceable r : remove) {
            this.unsetName(r);
        }
    }
}

