/*
 * Decompiled with CFR 0.152.
 */
package charlie.terms.replaceable;

import charlie.terms.replaceable.Replaceable;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;

public class ReplaceableList
implements Iterable<Replaceable> {
    private final TreeSet<Replaceable> _elements;
    public static final ReplaceableList EMPTY = new ReplaceableList();

    public ReplaceableList() {
        this._elements = new TreeSet();
    }

    public ReplaceableList(Replaceable x) {
        this._elements = new TreeSet();
        this._elements.add(x);
    }

    public ReplaceableList(Collection<Replaceable> elems) {
        this._elements = new TreeSet<Replaceable>(elems);
    }

    public boolean contains(Replaceable x) {
        return this._elements.contains(x);
    }

    public int size() {
        return this._elements.size();
    }

    @Override
    public Iterator<Replaceable> iterator() {
        return this._elements.iterator();
    }

    public ReplaceableList add(Replaceable x) {
        if (this._elements.contains(x)) {
            return this;
        }
        ReplaceableList ret = new ReplaceableList(this._elements);
        ret._elements.add(x);
        return ret;
    }

    public ReplaceableList remove(Replaceable x) {
        if (!this._elements.contains(x)) {
            return this;
        }
        ReplaceableList ret = new ReplaceableList(this._elements);
        ret._elements.remove(x);
        return ret;
    }

    public ReplaceableList combine(ReplaceableList other) {
        if (this.size() < other.size()) {
            return other.combine(this);
        }
        ReplaceableList ret = null;
        for (Replaceable x : other) {
            if (this._elements.contains(x)) continue;
            if (ret == null) {
                ret = new ReplaceableList(this._elements);
            }
            ret._elements.add(x);
        }
        if (ret == null) {
            return this;
        }
        return ret;
    }

    public TreeSet<Replaceable> getOverlap(Iterable<Replaceable> other) {
        TreeSet<Replaceable> ret = new TreeSet<Replaceable>();
        for (Replaceable x : other) {
            if (!this._elements.contains(x)) continue;
            ret.add(x);
        }
        return ret;
    }
}

