/*
 * Decompiled with CFR 0.152.
 */
package charlie.theorytranslation;

import charlie.smt.BVar;
import charlie.smt.Constraint;
import charlie.smt.IVar;
import charlie.smt.IntegerExpression;
import charlie.smt.SVar;
import charlie.smt.SmtSolver;
import charlie.smt.Valuation;
import charlie.substitution.MutableSubstitution;
import charlie.substitution.Substitution;
import charlie.terms.Term;
import charlie.terms.TheoryFactory;
import charlie.terms.Value;
import charlie.terms.Variable;
import charlie.theorytranslation.TermSmtTranslator;
import charlie.theorytranslation.UnsupportedTheoryException;
import charlie.types.Type;
import charlie.types.TypeFactory;
import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.Objects;
import java.util.Random;

public class TermAnalyser {
    private static Random _rnd = new Random();

    public static Value chooseRandomValue(Type type) {
        int r = _rnd.nextInt();
        if (type.equals(TypeFactory.intSort)) {
            return TheoryFactory.createValue(r);
        }
        if (type.equals(TypeFactory.boolSort)) {
            return TheoryFactory.createValue(r % 2 == 0);
        }
        if (type.equals(TypeFactory.stringSort)) {
            return TheoryFactory.createValue("{" + r + "}");
        }
        throw new UnsupportedTheoryException("Unsupported theory: I cannot choose a random value of type ", type, " because this theory sort is not yet supported by the SMT module.");
    }

    public static Value evaluate(Term t) {
        TermSmtTranslator translator = new TermSmtTranslator();
        if (t.queryType().equals(TypeFactory.intSort)) {
            IntegerExpression e = translator.translateIntegerExpression(t);
            return TheoryFactory.createValue(e.evaluate());
        }
        if (t.queryType().equals(TypeFactory.boolSort)) {
            Constraint c = translator.translateConstraint(t);
            return TheoryFactory.createValue(c.evaluate());
        }
        if (t.isValue()) {
            return t.toValue();
        }
        throw new UnsupportedTheoryException("Failed to translate ", t, " to SMT: its type (", t.queryType(), ") is not a supported theory sort.");
    }

    public static Value calculate(Term t) {
        if (!t.isFunctionalTerm() || t.queryRoot().toCalculationSymbol() == null) {
            return null;
        }
        for (int i = 1; i <= t.numberArguments(); ++i) {
            if (t.queryArgument(i).isValue()) continue;
            return null;
        }
        return TermAnalyser.evaluate(t);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Result satisfy(Term t, SmtSolver solver) {
        Record record;
        TermSmtTranslator translator = new TermSmtTranslator();
        translator.require(t);
        SmtSolver.Answer answer = solver.checkSatisfiability(translator.queryProblem());
        Objects.requireNonNull(answer);
        SmtSolver.Answer answer2 = answer;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SmtSolver.Answer.YES.class, SmtSolver.Answer.MAYBE.class, SmtSolver.Answer.NO.class}, (Object)answer2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                MutableSubstitution ret;
                Valuation val;
                SmtSolver.Answer.YES yES = (SmtSolver.Answer.YES)answer2;
                try {
                    Valuation valuation;
                    val = valuation = yES.val();
                    ret = new MutableSubstitution();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Iterator iterator = t.vars().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        record = new Result.YES(ret);
                        return record;
                    }
                    Variable x = (Variable)iterator.next();
                    if (x.queryType().equals(TypeFactory.boolSort)) {
                        BVar bvar = translator.getBVar(x);
                        ret.extend(x, TheoryFactory.createValue(val.queryAssignment(bvar)));
                        continue;
                    }
                    if (x.queryType().equals(TypeFactory.intSort)) {
                        IVar ivar = translator.getIVar(x);
                        ret.extend(x, TheoryFactory.createValue(val.queryAssignment(ivar)));
                        continue;
                    }
                    if (!x.queryType().equals(TypeFactory.stringSort)) continue;
                    SVar svar = translator.getSVar(x);
                    ret.extend(x, TheoryFactory.createValue(val.queryAssignment(svar)));
                }
            }
            case 1: {
                SmtSolver.Answer.MAYBE mAYBE = (SmtSolver.Answer.MAYBE)answer2;
                {
                    String string;
                    String reason = string = mAYBE.reason();
                    record = new Result.MAYBE(reason);
                    return record;
                }
            }
            case 2: 
        }
        SmtSolver.Answer.NO nO = (SmtSolver.Answer.NO)answer2;
        record = new Result.NO();
        return record;
    }

    public static sealed interface Result {

        public record MAYBE(String reason) implements Result
        {
        }

        public record NO() implements Result
        {
        }

        public record YES(Substitution subst) implements Result
        {
        }
    }
}

