/*
 * Decompiled with CFR 0.152.
 */
package charlie.theorytranslation;

import charlie.smt.BVar;
import charlie.smt.Constraint;
import charlie.smt.IVar;
import charlie.smt.IntegerExpression;
import charlie.smt.SVar;
import charlie.smt.SmtFactory;
import charlie.smt.SmtProblem;
import charlie.smt.StringExpression;
import charlie.terms.CalculationSymbol;
import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.TypingException;
import charlie.terms.Value;
import charlie.terms.Variable;
import charlie.theorytranslation.UnsupportedTheoryException;
import charlie.types.TypeFactory;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.TreeMap;

public class TermSmtTranslator {
    private SmtProblem _problem;
    private TreeMap<Variable, IVar> _ivars;
    private TreeMap<Variable, SVar> _svars;
    private TreeMap<Variable, BVar> _bvars;

    public TermSmtTranslator(SmtProblem problem) {
        this._problem = problem;
        this._ivars = new TreeMap();
        this._svars = new TreeMap();
        this._bvars = new TreeMap();
    }

    public TermSmtTranslator() {
        this._problem = new SmtProblem();
        this._ivars = new TreeMap();
        this._svars = new TreeMap();
        this._bvars = new TreeMap();
    }

    public SmtProblem queryProblem() {
        return this._problem;
    }

    private CalculationSymbol getCalculationRoot(Term t) {
        if (!t.isFunctionalTerm()) {
            throw new UnsupportedTheoryException("Failed to translate the term ", t, " to SMT: it is neither a variable nor a functional term.");
        }
        FunctionSymbol root = t.queryRoot();
        CalculationSymbol calc = root.toCalculationSymbol();
        if (calc == null) {
            throw new UnsupportedTheoryException("Failed to translate the term ", t, " to SMT: its root ", root, " is not a calculation symbol");
        }
        return calc;
    }

    private IVar getIntegerVariableFor(Variable x) {
        if (!this._ivars.containsKey(x)) {
            this._ivars.put(x, this._problem.createIntegerVariable());
        }
        return this._ivars.get(x);
    }

    private SVar getStringVariableFor(Variable x) {
        if (!this._svars.containsKey(x)) {
            this._svars.put(x, this._problem.createStringVariable());
        }
        return this._svars.get(x);
    }

    private BVar getBooleanVariableFor(Variable x) {
        if (!this._bvars.containsKey(x)) {
            this._bvars.put(x, this._problem.createBooleanVariable());
        }
        return this._bvars.get(x);
    }

    public IVar getIVar(Variable x) {
        return this._ivars.get(x);
    }

    public SVar getSVar(Variable x) {
        return this._svars.get(x);
    }

    public BVar getBVar(Variable x) {
        return this._bvars.get(x);
    }

    private Exp translate(Term t) {
        if (t.isVariable()) {
            Variable x = t.queryVariable();
            if (t.queryType().equals(TypeFactory.intSort)) {
                return new Exp.I(this.getIntegerVariableFor(x));
            }
            if (t.queryType().equals(TypeFactory.boolSort)) {
                return new Exp.B(this.getBooleanVariableFor(x));
            }
            if (t.queryType().equals(TypeFactory.stringSort)) {
                return new Exp.S(this.getStringVariableFor(x));
            }
            throw new UnsupportedTheoryException("Failed to translate term ", t, " to SMT: this is a variable of type ", t.queryType(), " which can neither be translated to an SMT expression nor to a constraint.");
        }
        if (t.isValue()) {
            Value v = t.toValue();
            if (v.isIntegerValue()) {
                return new Exp.I(SmtFactory.createValue(v.getInt()));
            }
            if (v.isStringValue()) {
                return new Exp.S(SmtFactory.createValue(v.getString()));
            }
            if (v.isBooleanValue()) {
                return new Exp.B(SmtFactory.createValue(v.getBool()));
            }
            throw new UnsupportedTheoryException("Failed to translate term ", t, " to SMT: this is a value, but not an integer, boolean or string value.");
        }
        CalculationSymbol calc = this.getCalculationRoot(t);
        return switch (calc.queryKind()) {
            default -> throw new MatchException(null, null);
            case CalculationSymbol.Kind.MINUS -> {
                this.assertArgumentCount(t, 1);
                yield new Exp.I(SmtFactory.createNegation(this.translateIntegerExpression(t.queryArgument(1))));
            }
            case CalculationSymbol.Kind.PLUS -> {
                this.assertArgumentCount(t, 2);
                yield new Exp.I(SmtFactory.createAddition(this.translateIntegerExpression(t.queryArgument(1)), this.translateIntegerExpression(t.queryArgument(2))));
            }
            case CalculationSymbol.Kind.TIMES -> {
                this.assertArgumentCount(t, 2);
                yield new Exp.I(SmtFactory.createMultiplication(this.translateIntegerExpression(t.queryArgument(1)), this.translateIntegerExpression(t.queryArgument(2))));
            }
            case CalculationSymbol.Kind.DIV -> {
                this.assertArgumentCount(t, 2);
                yield new Exp.I(SmtFactory.createDivision(this.translateIntegerExpression(t.queryArgument(1)), this.translateIntegerExpression(t.queryArgument(2))));
            }
            case CalculationSymbol.Kind.MOD -> {
                this.assertArgumentCount(t, 2);
                yield new Exp.I(SmtFactory.createModulo(this.translateIntegerExpression(t.queryArgument(1)), this.translateIntegerExpression(t.queryArgument(2))));
            }
            case CalculationSymbol.Kind.GREATER -> {
                this.assertArgumentCount(t, 2);
                yield new Exp.B(SmtFactory.createGreater(this.translateIntegerExpression(t.queryArgument(1)), this.translateIntegerExpression(t.queryArgument(2))));
            }
            case CalculationSymbol.Kind.SMALLER -> {
                this.assertArgumentCount(t, 2);
                yield new Exp.B(SmtFactory.createSmaller(this.translateIntegerExpression(t.queryArgument(1)), this.translateIntegerExpression(t.queryArgument(2))));
            }
            case CalculationSymbol.Kind.GEQ -> {
                this.assertArgumentCount(t, 2);
                yield new Exp.B(SmtFactory.createGeq(this.translateIntegerExpression(t.queryArgument(1)), this.translateIntegerExpression(t.queryArgument(2))));
            }
            case CalculationSymbol.Kind.LEQ -> {
                this.assertArgumentCount(t, 2);
                yield new Exp.B(SmtFactory.createLeq(this.translateIntegerExpression(t.queryArgument(1)), this.translateIntegerExpression(t.queryArgument(2))));
            }
            case CalculationSymbol.Kind.EQUALS -> {
                this.assertArgumentCount(t, 2);
                if (t.queryArgument(1).queryType().equals(TypeFactory.intSort)) {
                    yield new Exp.B(SmtFactory.createEqual(this.translateIntegerExpression(t.queryArgument(1)), this.translateIntegerExpression(t.queryArgument(2))));
                }
                yield new Exp.B(SmtFactory.createEqual(this.translateStringExpression(t.queryArgument(1)), this.translateStringExpression(t.queryArgument(2))));
            }
            case CalculationSymbol.Kind.NEQ -> {
                this.assertArgumentCount(t, 2);
                if (t.queryArgument(1).queryType().equals(TypeFactory.intSort)) {
                    yield new Exp.B(SmtFactory.createUnequal(this.translateIntegerExpression(t.queryArgument(1)), this.translateIntegerExpression(t.queryArgument(2))));
                }
                yield new Exp.B(SmtFactory.createUnequal(this.translateStringExpression(t.queryArgument(1)), this.translateStringExpression(t.queryArgument(2))));
            }
            case CalculationSymbol.Kind.AND -> {
                this.assertArgumentCount(t, 2);
                yield new Exp.B(SmtFactory.createConjunction(this.translateConstraint(t.queryArgument(1)), this.translateConstraint(t.queryArgument(2))));
            }
            case CalculationSymbol.Kind.OR -> {
                this.assertArgumentCount(t, 2);
                yield new Exp.B(SmtFactory.createDisjunction(this.translateConstraint(t.queryArgument(1)), this.translateConstraint(t.queryArgument(2))));
            }
            case CalculationSymbol.Kind.NOT -> {
                this.assertArgumentCount(t, 1);
                yield new Exp.B(SmtFactory.createNegation(this.translateConstraint(t.queryArgument(1))));
            }
            case CalculationSymbol.Kind.IFF -> {
                this.assertArgumentCount(t, 2);
                yield new Exp.B(SmtFactory.createIff(this.translateConstraint(t.queryArgument(1)), this.translateConstraint(t.queryArgument(2))));
            }
            case CalculationSymbol.Kind.XOR -> {
                this.assertArgumentCount(t, 2);
                yield new Exp.B(SmtFactory.createIff(this.translateConstraint(t.queryArgument(1)), this.translateConstraint(t.queryArgument(2))).negate());
            }
        };
    }

    private void assertArgumentCount(Term t, int numArgs) {
        if (t.numberArguments() != numArgs) {
            throw new UnsupportedTheoryException(new Object[]{"Failed to translate term ", t, " to SMT: the root symbol ", t.queryRoot(), " (of kind ", t.queryRoot().toCalculationSymbol().queryKind(), ") is expected to take " + numArgs + " arguments, not " + t.numberArguments() + "."});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IntegerExpression translateIntegerExpression(Term t) {
        Exp exp = this.translate(t);
        Objects.requireNonNull(exp);
        Exp exp2 = exp;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Exp.I.class}, (Object)exp2, n)) {
            case 0: {
                Exp.I i = (Exp.I)exp2;
                try {
                    IntegerExpression integerExpression = i.iexp();
                    return integerExpression;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        }
        throw new TypingException("Cannot translate ", t, " to an integer expression as it has type ", t.queryType(), " rather than Int.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StringExpression translateStringExpression(Term t) {
        Exp exp = this.translate(t);
        Objects.requireNonNull(exp);
        Exp exp2 = exp;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Exp.S.class}, (Object)exp2, n)) {
            case 0: {
                Exp.S s = (Exp.S)exp2;
                try {
                    StringExpression stringExpression = s.sexp();
                    return stringExpression;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        }
        throw new TypingException("Cannot translate ", t, " to a string expression as it has type ", t.queryType(), " rather than String.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Constraint translateConstraint(Term t) {
        Exp exp = this.translate(t);
        Objects.requireNonNull(exp);
        Exp exp2 = exp;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Exp.B.class}, (Object)exp2, n)) {
            case 0: {
                Exp.B b = (Exp.B)exp2;
                try {
                    Constraint constraint = b.bexp();
                    return constraint;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        }
        throw new TypingException("Cannot translate ", t, " to an SMT constraint as it has type ", t.queryType(), " rather than Bool.");
    }

    public void require(Term t) {
        this._problem.require(this.translateConstraint(t));
    }

    public void requireImplication(Term premise, Term conclusion) {
        this._problem.requireImplication(this.translateConstraint(premise), this.translateConstraint(conclusion));
    }

    private static sealed interface Exp {

        public record B(Constraint bexp) implements Exp
        {
        }

        public record S(StringExpression sexp) implements Exp
        {
        }

        public record I(IntegerExpression iexp) implements Exp
        {
        }
    }
}

