/*
 * Decompiled with CFR 0.152.
 */
package charlie.trs;

import charlie.terms.FunctionSymbol;
import charlie.terms.TypingException;
import charlie.util.LookupMap;
import charlie.util.NullStorageException;
import java.util.Collection;

public class Alphabet {
    private final LookupMap<FunctionSymbol> _symbols;

    public Alphabet(LookupMap<FunctionSymbol> symbols) {
        if (symbols == null) {
            throw new NullStorageException("Alphabet", "symbols list");
        }
        this._symbols = symbols;
    }

    public Alphabet(Collection<FunctionSymbol> symbols) {
        LookupMap.Builder<FunctionSymbol> builder = new LookupMap.Builder<FunctionSymbol>();
        if (symbols == null) {
            throw new NullStorageException("Alphabet", "symbols list");
        }
        for (FunctionSymbol f : symbols) {
            if (f == null) {
                throw new NullStorageException("Alphabet", "a symbol");
            }
            if (builder.containsKey(f.queryName())) {
                FunctionSymbol g = (FunctionSymbol)builder.get(f.queryName());
                if (g.equals(f)) continue;
                throw new TypingException("Duplicate occurrence of ", f, " in alphabet with different types: ", f.queryType(), " and ", g.queryType(), ".");
            }
            builder.put(f.queryName(), f);
        }
        this._symbols = builder.build();
    }

    public Alphabet add(Collection<FunctionSymbol> toadd) {
        LookupMap.Builder<FunctionSymbol> builder = new LookupMap.Builder<FunctionSymbol>();
        for (FunctionSymbol f : this._symbols.values()) {
            builder.put(f.queryName(), f);
        }
        for (FunctionSymbol f : toadd) {
            if (f == null) {
                throw new NullStorageException("Alphabet", "an extra symbol");
            }
            if (builder.containsKey(f.queryName())) {
                FunctionSymbol g = (FunctionSymbol)builder.get(f.queryName());
                if (g.equals(f)) continue;
                throw new TypingException("Duplicate occurrence of ", f, " in alphabet with different types: first occurrence has type ", g.queryType(), " while new occurrence has type ", f.queryType(), ".");
            }
            builder.put(f.queryName(), f);
        }
        return new Alphabet(builder.build());
    }

    public FunctionSymbol lookup(String name) {
        return this._symbols.get(name);
    }

    public Collection<FunctionSymbol> getSymbols() {
        return this._symbols.values();
    }

    public String toString() {
        StringBuilder ret = new StringBuilder("");
        for (FunctionSymbol symbol : this._symbols.values()) {
            ret.append(symbol.queryName());
            ret.append(" : ");
            ret.append(symbol.queryType());
            ret.append("\n");
        }
        return ret.toString();
    }
}

