/*
 * Decompiled with CFR 0.152.
 */
package charlie.trs;

import charlie.terms.Term;
import charlie.util.UserException;

public class IllegalRuleException
extends UserException {
    public IllegalRuleException(Term left, Term right, Term constraint, Object ... problem) {
        super(IllegalRuleException.makeArray(left, right, constraint, problem));
    }

    public IllegalRuleException(String message) {
        super(new Object[]{message});
    }

    private static Object[] makeArray(Term left, Term right, Term constraint, Object[] problem) {
        boolean printConstraint = constraint != null && (!constraint.isValue() || !constraint.toValue().getBool());
        Object[] parts = new Object[printConstraint ? 7 + problem.length : 5 + problem.length];
        parts[0] = "Illegal rule [";
        parts[1] = left;
        parts[2] = " -> ";
        parts[3] = right;
        int a = 4;
        if (printConstraint) {
            parts[4] = " | ";
            parts[5] = constraint;
            a = 6;
        }
        parts[a] = "]: ";
        for (Object p : problem) {
            parts[++a] = p;
        }
        return parts;
    }
}

