/*
 * Decompiled with CFR 0.152.
 */
package charlie.trs;

import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.TermPrinter;
import charlie.terms.TheoryFactory;
import charlie.terms.TypingException;
import charlie.terms.Value;
import charlie.terms.Variable;
import charlie.terms.replaceable.MutableRenaming;
import charlie.terms.replaceable.Replaceable;
import charlie.trs.IllegalRuleException;
import charlie.trs.RuleRestrictions;
import charlie.trs.TrsProperties;
import charlie.types.Type;
import charlie.types.TypeFactory;
import charlie.util.NullStorageException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;

public class Rule {
    private final Term _left;
    private final Term _right;
    private final Term _constraint;
    private final Set<Variable> _lvars;
    private Set<Variable> _tvars;
    private RuleRestrictions _properties;

    Rule(Term left, Term right, Term constraint) {
        this._left = left;
        this._right = right;
        this._constraint = constraint;
        this.checkCorrectness();
        this._lvars = Collections.unmodifiableSet(constraint.vars().toSet());
        this._tvars = null;
        this._properties = new RuleRestrictions(this._left, this._right, this._constraint, this._lvars);
    }

    Rule(Term left, Term right) {
        this._left = left;
        this._right = right;
        this._constraint = TheoryFactory.createValue(true);
        this.checkCorrectness();
        this._lvars = Set.of();
        this._tvars = null;
        this._properties = new RuleRestrictions(this._left, this._right, this._constraint, this._lvars);
    }

    public Term queryLeftSide() {
        return this._left;
    }

    public Term queryRightSide() {
        return this._right;
    }

    public Term queryConstraint() {
        return this._constraint;
    }

    public Set<Variable> queryLVars() {
        return this._lvars;
    }

    public Set<Variable> queryTVars() {
        if (this._tvars == null) {
            this._tvars = new TreeSet<Variable>();
            for (Variable x : this._constraint.vars()) {
                if (!this._left.freeReplaceables().contains(x) && !this._right.freeReplaceables().contains(x)) continue;
                this._tvars.add(x);
            }
            this._tvars = Collections.unmodifiableSet(this._tvars);
        }
        return this._tvars;
    }

    public Set<Replaceable> queryAllReplaceables() {
        TreeSet<Replaceable> ret = new TreeSet<Replaceable>();
        for (Replaceable x : this._left.freeReplaceables()) {
            ret.add(x);
        }
        for (Replaceable x : this._constraint.freeReplaceables()) {
            ret.add(x);
        }
        if (this._properties.rightReplaceablePolicy() == TrsProperties.FreshRight.ANY) {
            for (Replaceable x : this._right.freeReplaceables()) {
                ret.add(x);
            }
        }
        return ret;
    }

    RuleRestrictions queryProperties() {
        return this._properties;
    }

    public FunctionSymbol queryRoot() {
        if (this._left.isFunctionalTerm()) {
            return this._left.queryRoot();
        }
        return null;
    }

    public Type queryType() {
        return this._left.queryType();
    }

    public boolean isConstrained() {
        Value value = this._constraint.toValue();
        if (value == null) {
            return true;
        }
        return !value.getBool();
    }

    public boolean isFirstOrder() {
        return this._properties.queryLevel() == TrsProperties.Level.FIRSTORDER;
    }

    public boolean isApplicative() {
        return this._properties.queryLevel().compareTo(TrsProperties.Level.APPLICATIVE) <= 0;
    }

    public boolean isMetaFree() {
        return this._properties.queryLevel().compareTo(TrsProperties.Level.LAMBDA) <= 0;
    }

    public boolean isPatternRule() {
        return this._properties.patternStatus() == TrsProperties.Lhs.PATTERN;
    }

    public boolean isSemiPatternRule() {
        return this._properties.patternStatus().compareTo(TrsProperties.Lhs.SEMIPATTERN) <= 0;
    }

    public boolean isLeftLinear() {
        return this._left.isLinear();
    }

    public boolean queryTermFunctionRoot() {
        return this._properties.rootStatus() == TrsProperties.Root.FUNCTION;
    }

    public boolean queryFunctionRoot() {
        return this._properties.rootStatus().compareTo(TrsProperties.Root.THEORY) <= 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        TermPrinter printer = new TermPrinter(Set.of());
        MutableRenaming renaming = printer.generateUniqueNaming(this._left, this._right, this._constraint);
        printer.print(this._left, renaming, builder);
        builder.append(" \u2192 ");
        printer.print(this._right, renaming, builder);
        if (this.isConstrained()) {
            builder.append(" | ");
            printer.print(this._constraint, renaming, builder);
        }
        return builder.toString();
    }

    public TrsProperties.FreshRight queryRightReplaceablePolicy() {
        return this.queryProperties().rightReplaceablePolicy();
    }

    private void checkCorrectness() {
        this.checkNothingNull();
        this.checkTypesCorrect();
        this.checkBothSidesClosed();
        this.checkLeftNotTheory();
        this.checkConstraintTheory();
        this.checkConstraintFirstOrder();
    }

    private void checkNothingNull() {
        if (this._left == null) {
            throw new NullStorageException("Rule", "left-hand side");
        }
        if (this._right == null) {
            throw new NullStorageException("Rule", "right-hand side");
        }
        if (this._constraint == null) {
            throw new NullStorageException("Rule", "constraints");
        }
    }

    private void checkTypesCorrect() {
        if (!this._left.queryType().equals(this._right.queryType())) {
            throw new TypingException("Typing error creating rule: left-hand side ", this._left, " has type ", this._left.queryType(), " while right-hand side ", this._right, " has type ", this._right.queryType(), ".");
        }
        Type t = this._constraint.queryType();
        if (!t.equals(TypeFactory.boolSort) || !t.isTheoryType()) {
            throw new IllegalRuleException(this._left, this._right, this._constraint, "the constraint does not have type Bool (it has type ", t, ").");
        }
    }

    private void checkBothSidesClosed() {
        if (!this._left.isClosed()) {
            throw new IllegalRuleException(this._left, this._right, this._constraint, "the left-hand side is not closed (that is, it freely contains a binder-variable).");
        }
        if (!this._right.isClosed()) {
            throw new IllegalRuleException(this._left, this._right, this._constraint, "the right-hand side is not closed (that is, it freely contains a binder-variable).");
        }
    }

    private void checkLeftNotTheory() {
        LinkedList<Term> parts = new LinkedList<Term>();
        parts.add(this._left);
        boolean couldBeTheory = true;
        while (!parts.isEmpty() && couldBeTheory) {
            int i;
            Term t = (Term)parts.pop();
            if (!t.queryType().isTheoryType()) {
                couldBeTheory = false;
                continue;
            }
            if (t.isVariable() || t.isMetaApplication()) continue;
            if (t.isConstant()) {
                couldBeTheory = t.queryRoot().isTheorySymbol();
                continue;
            }
            if (t.isAbstraction()) {
                parts.add(t.queryAbstractionSubterm());
                continue;
            }
            if (t.isApplication()) {
                parts.add(t.queryHead());
                for (i = 1; i <= t.numberArguments(); ++i) {
                    parts.add(t.queryArgument(i));
                }
                continue;
            }
            if (!t.isTuple()) continue;
            for (i = 1; i <= t.numberTupleArguments(); ++i) {
                parts.add(t.queryTupleArgument(i));
            }
        }
        if (couldBeTheory) {
            if (this._left.isTheoryTerm()) {
                throw new IllegalRuleException(this._left, this._right, this._constraint, "the left-hand side is a theory term!");
            }
            throw new IllegalRuleException(this._left, this._right, this._constraint, "the left-hand side could be instantiated to a theory term!");
        }
    }

    private void checkConstraintTheory() {
        if (!this._constraint.isTheoryTerm()) {
            throw new IllegalRuleException(this._left, this._right, this._constraint, "the constraint is not a theory term.");
        }
    }

    private void checkConstraintFirstOrder() {
        if (!this._constraint.isFirstOrder()) {
            throw new IllegalRuleException(this._left, this._right, this._constraint, "the constraint is not first-order.");
        }
    }
}

