/*
 * Decompiled with CFR 0.152.
 */
package charlie.trs;

import charlie.terms.Term;
import charlie.terms.Variable;
import charlie.terms.position.Position;
import charlie.terms.replaceable.Replaceable;
import charlie.terms.replaceable.ReplaceableList;
import charlie.trs.TrsProperties;
import charlie.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Map;

class RuleRestrictions {
    private TrsProperties.Level _level;
    private boolean _theories;
    private boolean _products;
    private TrsProperties.Lhs _pattern;
    private TrsProperties.Root _rootStatus;
    private TrsProperties.FreshRight _fresh;

    TrsProperties.Level queryLevel() {
        return this._level;
    }

    boolean theoriesUsed() {
        return this._theories;
    }

    boolean productsUsed() {
        return this._products;
    }

    TrsProperties.Lhs patternStatus() {
        return this._pattern;
    }

    TrsProperties.Root rootStatus() {
        return this._rootStatus;
    }

    TrsProperties.FreshRight rightReplaceablePolicy() {
        return this._fresh;
    }

    RuleRestrictions() {
        this._level = TrsProperties.Level.FIRSTORDER;
        this._theories = false;
        this._products = false;
        this._pattern = TrsProperties.Lhs.PATTERN;
        this._rootStatus = TrsProperties.Root.FUNCTION;
        this._fresh = TrsProperties.FreshRight.NONE;
    }

    RuleRestrictions(TrsProperties.Level lvl, TrsProperties.Constrained theories, TrsProperties.TypeLevel types, TrsProperties.Lhs pattern, TrsProperties.Root rootstat, TrsProperties.FreshRight fresh) {
        this._level = lvl;
        this._theories = theories == TrsProperties.Constrained.YES;
        this._products = types == TrsProperties.TypeLevel.SIMPLEPRODUCTS;
        this._pattern = pattern;
        this._rootStatus = rootstat;
        this._fresh = fresh;
    }

    RuleRestrictions(Term left, Term right, Term constraint, Collection<Variable> lvars) {
        this._level = left.isFirstOrder() && right.isFirstOrder() ? TrsProperties.Level.FIRSTORDER : (left.isApplicative() && right.isApplicative() ? TrsProperties.Level.APPLICATIVE : (left.isTrueTerm() && right.isTrueTerm() ? TrsProperties.Level.LAMBDA : TrsProperties.Level.META));
        this._pattern = left.isPattern() ? TrsProperties.Lhs.PATTERN : (this._level != TrsProperties.Level.META ? TrsProperties.Lhs.SEMIPATTERN : (left.isSemiPattern() ? TrsProperties.Lhs.SEMIPATTERN : TrsProperties.Lhs.NONPATTERN));
        this._rootStatus = !left.isFunctionalTerm() ? TrsProperties.Root.ANY : (left.queryRoot().isTheorySymbol() ? TrsProperties.Root.THEORY : TrsProperties.Root.FUNCTION);
        this._theories = false;
        this._products = false;
        List<Pair<Term, Position>> subterms = left.querySubterms();
        subterms.addAll(right.querySubterms());
        if (!constraint.isValue() || !constraint.toValue().getBool()) {
            this._theories = true;
            subterms.addAll(constraint.querySubterms());
        }
        for (int i = 0; !(i >= subterms.size() || this._theories && this._products); ++i) {
            Term sub = subterms.get(i).fst();
            if (sub.isFunctionalTerm() && sub.queryRoot().isTheorySymbol()) {
                this._theories = true;
            }
            if (!sub.queryType().hasProducts()) continue;
            this._products = true;
        }
        this._fresh = TrsProperties.FreshRight.NONE;
        ReplaceableList inleft = left.freeReplaceables();
        ReplaceableList incons = constraint.freeReplaceables();
        for (Replaceable x : right.freeReplaceables()) {
            if (inleft.contains(x)) continue;
            if (incons.contains(x)) {
                this._fresh = TrsProperties.FreshRight.CVARS;
                continue;
            }
            this._fresh = TrsProperties.FreshRight.ANY;
            break;
        }
    }

    String checkCoverage(RuleRestrictions other) {
        if (this._level.compareTo(other._level) < 0) {
            Map<TrsProperties.Level, String> explanation = Map.of(TrsProperties.Level.FIRSTORDER, "first-order ", TrsProperties.Level.APPLICATIVE, "applicative ", TrsProperties.Level.LAMBDA, "true ", TrsProperties.Level.META, "meta-");
            return "the rule level is limited to " + explanation.get((Object)this._level) + "terms, not " + explanation.get((Object)other._level) + "terms.";
        }
        if (this._rootStatus.compareTo(other._rootStatus) < 0) {
            String original = switch (this._rootStatus) {
                default -> throw new MatchException(null, null);
                case TrsProperties.Root.FUNCTION -> "a non-theory function symbol";
                case TrsProperties.Root.THEORY -> "a function symbol";
                case TrsProperties.Root.ANY -> "MEH THERE IS A BUG IN CHECKCOVERAGE";
            };
            String real = switch (other._rootStatus) {
                default -> throw new MatchException(null, null);
                case TrsProperties.Root.FUNCTION -> "EEK THERE IS A BUG IN CHECKCOVERAGE";
                case TrsProperties.Root.THEORY -> "a theory symbol";
                case TrsProperties.Root.ANY -> "anything else";
            };
            return "the left-hand side should have " + original + " as root, not " + real + ".";
        }
        if (this._pattern.compareTo(other._pattern) < 0) {
            Map<TrsProperties.Lhs, String> explanation = Map.of(TrsProperties.Lhs.PATTERN, "pattern", TrsProperties.Lhs.SEMIPATTERN, "semi-pattern", TrsProperties.Lhs.NONPATTERN, "non-pattern");
            return "the left-hand side should be a " + explanation.get((Object)this._pattern) + ", not a " + explanation.get((Object)other._pattern) + ".";
        }
        if (this._fresh.compareTo(other._fresh) < 0) {
            return "the right-hand side contains a " + (other._level == TrsProperties.Level.META ? "meta-" : "") + "variable that does not occur in the left-hand side" + (this._fresh == TrsProperties.FreshRight.NONE ? "" : " or the constraint") + ".";
        }
        if (!this._theories && other._theories) {
            return "the use of theory symbols / constraints is not supported.";
        }
        if (!this._products && other._products) {
            return "the use of tuples (or any occurrence of product types) is not supported.";
        }
        return null;
    }

    boolean covers(RuleRestrictions other) {
        return this.checkCoverage(other) == null;
    }

    RuleRestrictions supremum(RuleRestrictions other) {
        TrsProperties.Level maxlevel = this._level;
        TrsProperties.Root maxroot = this._rootStatus;
        TrsProperties.Lhs maxpattern = this._pattern;
        TrsProperties.FreshRight maxfresh = this._fresh;
        boolean maxtheories = this._theories;
        boolean maxproducts = this._products;
        if (other._level.compareTo(maxlevel) > 0) {
            maxlevel = other._level;
        }
        if (other._rootStatus.compareTo(maxroot) > 0) {
            maxroot = other._rootStatus;
        }
        if (other._pattern.compareTo(maxpattern) > 0) {
            maxpattern = other._pattern;
        }
        if (other._fresh.compareTo(maxfresh) > 0) {
            maxfresh = other._fresh;
        }
        if (other._theories) {
            maxtheories = true;
        }
        if (other._products) {
            maxproducts = true;
        }
        return new RuleRestrictions(maxlevel, maxtheories ? TrsProperties.Constrained.YES : TrsProperties.Constrained.NO, maxproducts ? TrsProperties.TypeLevel.SIMPLEPRODUCTS : TrsProperties.TypeLevel.SIMPLE, maxpattern, maxroot, maxfresh);
    }

    public String toString() {
        return "{ " + String.valueOf((Object)this._level) + " ; " + this._theories + " ; " + this._products + " ; " + String.valueOf((Object)this._pattern) + " ; " + String.valueOf((Object)this._rootStatus) + " ; " + String.valueOf((Object)this._fresh) + " }";
    }
}

