/*
 * Decompiled with CFR 0.152.
 */
package charlie.trs;

import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.trs.Alphabet;
import charlie.trs.IllegalRuleException;
import charlie.trs.IllegalSymbolException;
import charlie.trs.Rule;
import charlie.trs.RuleRestrictions;
import charlie.trs.TrsProperties;
import charlie.types.Type;
import charlie.util.FixedList;
import charlie.util.NullStorageException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TRS {
    private final Alphabet _alphabet;
    private final FixedList<Rule> _rules;
    private final FixedList<RuleScheme> _schemes;
    private final TreeSet<String> _private;
    private TreeSet<FunctionSymbol> _defined;
    private String _trsKind;
    private TrsProperties.TermLevel _level;
    private boolean _theoriesIncluded;
    private boolean _productsIncluded;
    private RuleRestrictions _rulesProperties;
    private HashMap<FunctionSymbol, List<Rule>> _functionRules;
    private LinkedList<Rule> _variableRules;

    TRS(Alphabet alphabet, List<Rule> rules, FixedList<RuleScheme> schemes, Collection<String> privateSymbols, String trsKindName, TrsProperties.TermLevel trsLevel, boolean includeTheories, boolean includeProducts, RuleRestrictions restrictions) {
        this._alphabet = alphabet;
        this._rules = FixedList.copy(rules);
        this._schemes = schemes;
        this._private = privateSymbols == null ? new TreeSet() : new TreeSet<String>(privateSymbols);
        this.construct(trsKindName, trsLevel, includeTheories, includeProducts, restrictions);
    }

    TRS(Alphabet alphabet, FixedList<Rule> rules, FixedList<RuleScheme> schemes, Collection<String> privateSymbols, String trsKindName, TrsProperties.TermLevel trsLevel, boolean includeTheories, boolean includeProducts, RuleRestrictions restrictions) {
        this._alphabet = alphabet;
        this._rules = rules;
        this._schemes = schemes;
        this._private = privateSymbols == null ? new TreeSet() : new TreeSet<String>(privateSymbols);
        this.construct(trsKindName, trsLevel, includeTheories, includeProducts, restrictions);
    }

    private void construct(String trsKindName, TrsProperties.TermLevel trsLevel, boolean includeTheories, boolean includeProducts, RuleRestrictions restrictions) {
        String problem;
        if (this._alphabet == null) {
            throw new NullStorageException("TRS", "alphabet");
        }
        if (this._rules == null) {
            throw new NullStorageException("TRS", "rules");
        }
        if (this._schemes == null) {
            throw new NullStorageException("TRS", "rule schemes");
        }
        this._theoriesIncluded = includeTheories;
        this._productsIncluded = includeProducts;
        this._level = trsLevel;
        this._trsKind = trsKindName;
        this._defined = new TreeSet();
        this.verifyAlphabet();
        this._rulesProperties = new RuleRestrictions();
        for (Rule rule : this._rules) {
            if (rule == null) {
                throw new NullStorageException("TRS", "one of the rules");
            }
            this._rulesProperties = this._rulesProperties.supremum(rule.queryProperties());
            FunctionSymbol root = rule.queryRoot();
            if (root == null) continue;
            this._defined.add(root);
        }
        if (restrictions != null && (problem = restrictions.checkCoverage(this._rulesProperties)) != null) {
            throw new IllegalRuleException("The given rules are not suitable for " + trsKindName + "s because " + problem);
        }
        this._functionRules = null;
        this._variableRules = null;
    }

    private void verifyAlphabet() {
        for (FunctionSymbol f : this._alphabet.getSymbols()) {
            Type type = f.queryType();
            if (this._level == TrsProperties.TermLevel.FIRSTORDER && type.queryTypeOrder() > 1) {
                throw new IllegalSymbolException(f, this._trsKind, "higher-order symbols cannot occur in a first-order TRS.");
            }
            if (this._productsIncluded || !type.hasProducts()) continue;
            throw new IllegalSymbolException(f, this._trsKind, "product types cannot occur in a product-free TRS.");
        }
    }

    public Alphabet queryAlphabet() {
        return this._alphabet;
    }

    public Set<String> queryPrivateSymbols() {
        return Collections.unmodifiableSet(this._private);
    }

    public boolean isPrivate(FunctionSymbol symbol) {
        return this._private.contains(symbol.queryName());
    }

    public boolean isDefined(FunctionSymbol symbol) {
        return this._defined.contains(symbol);
    }

    public int queryRuleCount() {
        return this._rules.size();
    }

    public Rule queryRule(int index) {
        return this._rules.get(index);
    }

    public FixedList<Rule> queryRules() {
        return this._rules;
    }

    public int querySchemeCount() {
        return this._schemes.size();
    }

    public RuleScheme queryScheme(int index) {
        return this._schemes.get(index);
    }

    public String queryTrsKind() {
        return this._trsKind;
    }

    public TreeSet<FunctionSymbol> definedSymbols() {
        return new TreeSet<FunctionSymbol>((SortedSet<FunctionSymbol>)this._defined);
    }

    public Set<String> queryFunctionSymbolNames() {
        return this._alphabet.getSymbols().stream().map(FunctionSymbol::queryName).collect(Collectors.toSet());
    }

    public FunctionSymbol lookupSymbol(String name) {
        return this._alphabet.lookup(name);
    }

    public boolean theoriesIncluded() {
        return this._theoriesIncluded;
    }

    public boolean productsIncluded() {
        return this._productsIncluded;
    }

    public boolean isFirstOrder() {
        return this._level == TrsProperties.TermLevel.FIRSTORDER;
    }

    public boolean isApplicative() {
        return this._level.compareTo(TrsProperties.TermLevel.APPLICATIVE) <= 0;
    }

    public boolean isLeftLinear() {
        for (int i = 0; i < this._rules.size(); ++i) {
            if (this._rules.get(i).isLeftLinear()) continue;
            return false;
        }
        return true;
    }

    public TRS createDerivative(List<Rule> newrules, Alphabet newAlphabet) {
        return new TRS(newAlphabet, newrules, this._schemes, this._private, this._trsKind, this._level, this._theoriesIncluded, this._productsIncluded, null);
    }

    public TRS createDerivative(FixedList<Rule> newrules, Alphabet newAlphabet) {
        return new TRS(newAlphabet, newrules, this._schemes, this._private, this._trsKind, this._level, this._theoriesIncluded, this._productsIncluded, null);
    }

    public TRS createDerivative(List<Rule> newrules) {
        return new TRS(this._alphabet, newrules, this._schemes, this._private, this._trsKind, this._level, this._theoriesIncluded, this._productsIncluded, null);
    }

    public boolean verifyProperties(TrsProperties.Level lvl, TrsProperties.Constrained theories, TrsProperties.TypeLevel types, TrsProperties.Lhs pattern, TrsProperties.Root rootstat, TrsProperties.FreshRight fresh, RuleScheme ... additionalSchemes) {
        if (this._theoriesIncluded && theories == TrsProperties.Constrained.NO) {
            return false;
        }
        if (this._productsIncluded && types == TrsProperties.TypeLevel.SIMPLE) {
            return false;
        }
        if (TrsProperties.translateRuleToTermLevel(lvl).compareTo(this._level) < 0) {
            return false;
        }
        if (!this.schemesIncluded(additionalSchemes)) {
            return false;
        }
        RuleRestrictions rest = new RuleRestrictions(lvl, theories, types, pattern, rootstat, fresh);
        return rest.covers(this._rulesProperties);
    }

    public boolean verifyProperties(TrsProperties.Level ruleLevel, TrsProperties.Constrained ruleTheories, TrsProperties.TypeLevel ruleTypes, TrsProperties.Lhs pattern, TrsProperties.Root rootstat, TrsProperties.FreshRight ruleFreshPolicy, TrsProperties.TermLevel termLevel, TrsProperties.Constrained termTheories, TrsProperties.TypeLevel termTypes, RuleScheme ... additionalSchemes) {
        if (this._theoriesIncluded && termTheories == TrsProperties.Constrained.NO) {
            return false;
        }
        if (this._productsIncluded && termTypes == TrsProperties.TypeLevel.SIMPLE) {
            return false;
        }
        if (termLevel.compareTo(this._level) < 0) {
            return false;
        }
        if (!this.schemesIncluded(additionalSchemes)) {
            return false;
        }
        RuleRestrictions rest = new RuleRestrictions(ruleLevel, ruleTheories, ruleTypes, pattern, rootstat, ruleFreshPolicy);
        return rest.covers(this._rulesProperties);
    }

    private boolean schemesIncluded(RuleScheme[] supported) {
        if (!this._schemes.contains(RuleScheme.Eta)) {
            return true;
        }
        for (RuleScheme s : supported) {
            if (s != RuleScheme.Eta) continue;
            return true;
        }
        return false;
    }

    public boolean termAllowed(Term term) {
        if (this.isFirstOrder() ? !term.isFirstOrder() : this.isApplicative() && !term.isApplicative()) {
            return false;
        }
        if (this._productsIncluded && this._theoriesIncluded) {
            return true;
        }
        return null == term.findSubterm((sub, pos) -> !this._theoriesIncluded && sub.isFunctionalTerm() && sub.queryRoot().isTheorySymbol() || !this._productsIncluded && sub.queryType().hasProducts());
    }

    public String toString() {
        int i;
        StringBuilder ret = new StringBuilder();
        ret.append("\u03a3 = {\n");
        for (FunctionSymbol f : this._alphabet.getSymbols()) {
            ret.append("  " + f.queryName() + " :: " + String.valueOf(f.queryType()));
            if (this._private.contains(f.queryName())) {
                ret.append("  (private)");
            }
            ret.append("\n");
        }
        if (this._theoriesIncluded) {
            ret.append("} \u222a \u03a3_{theory}\n");
        } else {
            ret.append("}\n");
        }
        ret.append("R = {\n");
        for (i = 0; i < this._rules.size(); ++i) {
            ret.append("  ");
            ret.append(this._rules.get(i).toString());
            ret.append("\n");
        }
        ret.append("}\n");
        if (this._schemes.size() != 0) {
            ret.append("We also include the following rule schemes: ");
        }
        for (i = 0; i < this._schemes.size(); ++i) {
            if (i != 0) {
                ret.append(", ");
            }
            ret.append(this._schemes.get(i).toString());
        }
        ret.append("\n");
        return ret.toString();
    }

    public Stream<Rule> queryRulesForSymbol(FunctionSymbol func, boolean withVar) {
        if (this._functionRules == null) {
            this.computeRulesCache();
        }
        List funcRules = this._functionRules.getOrDefault(func, new LinkedList());
        if (!withVar) {
            return funcRules.stream();
        }
        Type functype = func.queryType();
        return Stream.concat(funcRules.stream(), this._variableRules.stream().filter(r -> this.isPotentialOutputType(functype, r.queryLeftSide().queryHead().queryType())));
    }

    private void computeRulesCache() {
        this._functionRules = new HashMap();
        this._variableRules = new LinkedList();
        for (Rule rule : this.queryRules()) {
            Term lhs = rule.queryLeftSide();
            if (lhs.isFunctionalTerm()) {
                FunctionSymbol f = lhs.queryRoot();
                List l = this._functionRules.getOrDefault(f, new LinkedList());
                l.add(rule);
                this._functionRules.put(f, l);
                continue;
            }
            if (!lhs.queryHead().isMetaApplication()) continue;
            this._variableRules.add(rule);
        }
    }

    private boolean isPotentialOutputType(Type longtype, Type outputtype) {
        int nArgs = longtype.queryArity() - outputtype.queryArity();
        if (nArgs < 0) {
            return false;
        }
        while (nArgs > 0 && longtype.isArrowType()) {
            --nArgs;
            longtype = longtype.subtype(2);
        }
        return longtype.equals(outputtype);
    }

    public int queryRuleArity(FunctionSymbol f) {
        boolean first = true;
        int ret = 0;
        if (this._functionRules == null) {
            this.computeRulesCache();
        }
        if (f.isTheorySymbol()) {
            ret = f.queryArity();
            first = false;
        }
        if (!this._functionRules.containsKey(f)) {
            return ret;
        }
        for (Rule rule : this._functionRules.get(f)) {
            if (first) {
                ret = rule.queryLeftSide().numberArguments();
                first = false;
                continue;
            }
            if (ret == rule.queryLeftSide().numberArguments()) continue;
            return -1;
        }
        return ret;
    }

    public static enum RuleScheme {
        Beta,
        Eta,
        Calc;

    }
}

