/*
 * Decompiled with CFR 0.152.
 */
package charlie.trs;

import charlie.terms.Term;
import charlie.trs.Alphabet;
import charlie.trs.IllegalRuleException;
import charlie.trs.Rule;
import charlie.trs.RuleRestrictions;
import charlie.trs.TRS;
import charlie.trs.TrsProperties;
import charlie.util.FixedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class TrsFactory {
    public static final TrsKind MSTRS = new TrsKind("MSTRS", TrsProperties.Level.FIRSTORDER, TrsProperties.Constrained.NO, TrsProperties.TypeLevel.SIMPLE, TrsProperties.Lhs.PATTERN, TrsProperties.Root.FUNCTION, TrsProperties.FreshRight.NONE);
    public static final TrsKind STRS = new TrsKind("STRS", TrsProperties.Level.APPLICATIVE, TrsProperties.Constrained.NO, TrsProperties.TypeLevel.SIMPLE, TrsProperties.Lhs.SEMIPATTERN, TrsProperties.Root.ANY, TrsProperties.FreshRight.NONE);
    public static final TrsKind CFS = new TrsKind("CFS", TrsProperties.Level.LAMBDA, TrsProperties.Constrained.NO, TrsProperties.TypeLevel.SIMPLE, TrsProperties.Lhs.SEMIPATTERN, TrsProperties.Root.ANY, TrsProperties.FreshRight.NONE);
    public static final TrsKind AMS = new TrsKind("AMS", TrsProperties.Level.META, TrsProperties.Constrained.NO, TrsProperties.TypeLevel.SIMPLE, TrsProperties.Lhs.SEMIPATTERN, TrsProperties.Root.ANY, TrsProperties.FreshRight.NONE);
    public static final TrsKind LCTRS = new TrsKind("LCTRS", TrsProperties.Level.FIRSTORDER, TrsProperties.Constrained.YES, TrsProperties.TypeLevel.SIMPLE, TrsProperties.Lhs.PATTERN, TrsProperties.Root.THEORY, TrsProperties.FreshRight.CVARS);
    public static final TrsKind LCSTRS = new TrsKind("LCSTRS", TrsProperties.Level.APPLICATIVE, TrsProperties.Constrained.YES, TrsProperties.TypeLevel.SIMPLE, TrsProperties.Lhs.SEMIPATTERN, TrsProperties.Root.ANY, TrsProperties.FreshRight.CVARS);
    public static final TrsKind CORA = new TrsKind("Cora-TRS", TrsProperties.Level.META, TrsProperties.Constrained.YES, TrsProperties.TypeLevel.SIMPLEPRODUCTS, TrsProperties.Lhs.NONPATTERN, TrsProperties.Root.ANY, TrsProperties.FreshRight.ANY);

    private static void checkRestrictions(Rule rule, TrsKind kind) {
        String problem = kind._restrictions.checkCoverage(rule.queryProperties());
        if (problem == null) {
            return;
        }
        throw new IllegalRuleException(rule.queryLeftSide(), rule.queryRightSide(), rule.queryConstraint(), "this rule may not occur in " + kind._name + "s because " + problem);
    }

    public static Rule createRule(Term left, Term right, TrsKind restrictions) {
        Rule rule = new Rule(left, right);
        TrsFactory.checkRestrictions(rule, restrictions);
        return rule;
    }

    public static Rule createRule(Term left, Term right) {
        return new Rule(left, right);
    }

    public static Rule createRule(Term left, Term right, Term constraint, TrsKind restrictions) {
        Rule rule = new Rule(left, right, constraint);
        TrsFactory.checkRestrictions(rule, restrictions);
        return rule;
    }

    public static Rule createRule(Term left, Term right, Term constraint) {
        return new Rule(left, right, constraint);
    }

    public static TRS createTrs(Alphabet alphabet, List<Rule> rules, Set<String> privateSymbols, boolean includeEta, TrsKind kind) {
        FixedList.Builder<TRS.RuleScheme> newschemes = new FixedList.Builder<TRS.RuleScheme>();
        if (kind._restrictions.queryLevel().compareTo(TrsProperties.Level.LAMBDA) >= 0) {
            newschemes.add(TRS.RuleScheme.Beta);
            if (includeEta) {
                newschemes.add(TRS.RuleScheme.Eta);
            }
        } else if (includeEta) {
            throw new IllegalRuleException("Eta can only be added to TRSs whose term formation includes abstraction.");
        }
        if (kind._restrictions.theoriesUsed()) {
            newschemes.add(TRS.RuleScheme.Calc);
        }
        return new TRS(alphabet, rules, newschemes.build(), privateSymbols, kind._name, TrsProperties.translateRuleToTermLevel(kind._restrictions.queryLevel()), kind._restrictions.theoriesUsed(), kind._restrictions.productsUsed(), kind._restrictions);
    }

    public static TRS createTrs(Alphabet alphabet, List<Rule> rules, TrsKind kind) {
        return TrsFactory.createTrs(alphabet, rules, new TreeSet<String>(), false, kind);
    }

    public static class TrsKind {
        private String _name;
        private RuleRestrictions _restrictions;

        private TrsKind(String name, TrsProperties.Level lvl, TrsProperties.Constrained theories, TrsProperties.TypeLevel tlvl, TrsProperties.Lhs pattern, TrsProperties.Root rootstat, TrsProperties.FreshRight fresh) {
            this._name = name;
            this._restrictions = new RuleRestrictions(lvl, theories, tlvl, pattern, rootstat, fresh);
        }

        public boolean theoriesIncluded() {
            return this._restrictions.theoriesUsed();
        }

        public String toString() {
            return this._name + " with " + this._restrictions.toString();
        }
    }
}

