/*
 * Decompiled with CFR 0.152.
 */
package charlie.types;

import charlie.types.Type;
import charlie.types.TypePrinter;
import charlie.util.NullStorageException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public record Arrow(Type left, Type right) implements Type
{
    public Arrow {
        if (left == null || right == null) {
            throw new NullStorageException("Arrow", "type");
        }
    }

    @Override
    public boolean isArrowType() {
        return true;
    }

    @Override
    public String toString() {
        return new TypePrinter().print(this);
    }

    @Override
    public boolean isTheoryType() {
        return this.left.isTheoryType() && this.right.isTheoryType();
    }

    @Override
    public boolean hasProducts() {
        return this.left.hasProducts() || this.right.hasProducts();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Type type) {
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Arrow.class}, (Object)type3, n)) {
            case 0: {
                Arrow arrow = (Arrow)type3;
                try {
                    Type type4;
                    Type l = type4 = arrow.left();
                    Type r = type4 = arrow.right();
                    if (!this.left.equals(l)) return false;
                    if (!this.right.equals(r)) return false;
                    return true;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object other) {
        Type t;
        return other instanceof Type && this.equals(t = (Type)other);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }

    @Override
    public int queryArity() {
        return 1 + this.right.queryArity();
    }

    @Override
    public Type queryOutputType() {
        return this.right.queryOutputType();
    }

    @Override
    public int queryTypeOrder() {
        return Math.max(1 + this.left.queryTypeOrder(), this.right.queryTypeOrder());
    }

    @Override
    public int numberSubtypes() {
        return 2;
    }

    @Override
    public Type subtype(int index) {
        if (index == 1) {
            return this.left;
        }
        if (index == 2) {
            return this.right;
        }
        throw new IndexOutOfBoundsException("Arrow::subtype given " + index + " (expected 1-2).");
    }
}

