/*
 * Decompiled with CFR 0.152.
 */
package charlie.types;

import charlie.types.Type;
import charlie.types.TypePrinter;
import charlie.util.FixedList;
import charlie.util.NullStorageException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public record Product(FixedList<Type> types) implements Type
{
    public Product {
        if (types == null) {
            throw new NullStorageException("Product", "product list");
        }
        if (types.size() < 2) {
            throw new IllegalArgumentException("product list has size " + types.size() + "; should be at least 2");
        }
    }

    @Override
    public boolean isProductType() {
        return true;
    }

    @Override
    public boolean isTheoryType() {
        return this.types.stream().allMatch(Type::isTheoryType);
    }

    @Override
    public boolean hasProducts() {
        return true;
    }

    @Override
    public String toString() {
        return new TypePrinter().print(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Type type) {
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Product.class}, (Object)type3, n)) {
            case 0: {
                Product product = (Product)type3;
                try {
                    FixedList<Type> fixedList;
                    FixedList<Type> componentTypes = fixedList = product.types();
                    return this.types.equals(componentTypes);
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object other) {
        Type t;
        return other instanceof Type && this.equals(t = (Type)other);
    }

    @Override
    public int hashCode() {
        return this.types.hashCode();
    }

    @Override
    public Type queryOutputType() {
        return this;
    }

    @Override
    public int queryTypeOrder() {
        return this.types.stream().map(Type::queryTypeOrder).reduce(0, (n, m) -> Math.max(n, m));
    }

    @Override
    public int numberSubtypes() {
        return this.types.size();
    }

    @Override
    public Type subtype(int index) {
        if (index <= 0 || index > this.types.size()) {
            throw new IndexOutOfBoundsException("Product::subtype called with index " + index + "on tuple type [" + this.toString() + "] with " + this.types.size() + " elements.");
        }
        return this.types.get(index - 1);
    }
}

