/*
 * Decompiled with CFR 0.152.
 */
package charlie.types;

import charlie.types.Arrow;
import charlie.types.Base;
import charlie.types.Product;
import charlie.types.Type;
import charlie.types.UniqueTypes;
import charlie.util.FixedList;
import java.util.List;

public class TypeFactory {
    public static final Base intSort = UniqueTypes.intSort;
    public static final Base boolSort = UniqueTypes.boolSort;
    public static final Base stringSort = UniqueTypes.stringSort;
    public static final Base defaultSort = UniqueTypes.defaultSort;

    public static Base createSort(String name) {
        return new Base(name);
    }

    public static Type createArrow(Type left, Type right) {
        return new Arrow(left, right);
    }

    public static Type createProduct(FixedList<Type> types) {
        if (types.size() == 1) {
            return types.get(0);
        }
        return new Product(types);
    }

    public static Type createProduct(List<Type> types) {
        if (types.size() == 1) {
            return types.get(0);
        }
        return new Product(FixedList.copy(types));
    }

    public static Type createProduct(Type ... args) {
        return new Product(FixedList.of(args));
    }

    public static Type createSortDeclaration(List<Base> inputs, Base output) {
        Record ret = output;
        for (int i = inputs.size() - 1; i >= 0; --i) {
            ret = new Arrow(inputs.get(i), (Type)((Object)ret));
        }
        return ret;
    }

    public static Type createDefaultArrow(int arity) {
        Record ret = defaultSort;
        for (int i = 0; i < arity; ++i) {
            ret = new Arrow(defaultSort, (Type)((Object)ret));
        }
        return ret;
    }
}

