/*
 * Decompiled with CFR 0.152.
 */
package charlie.types;

import charlie.types.Arrow;
import charlie.types.Base;
import charlie.types.Product;
import charlie.types.Type;
import charlie.util.FixedList;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public class TypePrinter {
    public final String print(Type t) {
        StringBuilder builder = new StringBuilder();
        this.print(t, builder);
        return builder.toString();
    }

    public void print(Type t, StringBuilder builder) {
        Type type = t;
        Objects.requireNonNull(type);
        Type type2 = type;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Base.class, Arrow.class, Product.class}, (Object)type2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                String string;
                Base base = (Base)type2;
                String name = string = base.name();
                this.printBaseType(name, builder);
                break;
            }
            case 1: {
                Type type3;
                Arrow arrow = (Arrow)type2;
                Type left = type3 = arrow.left();
                Type right = type3 = arrow.right();
                this.printArrowType(left, right, builder);
                break;
            }
            case 2: {
                Product product = (Product)type2;
                try {
                    FixedList<Type> fixedList;
                    FixedList<Type> elems = fixedList = product.types();
                    this.printProductType(elems, builder);
                    break;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        }
    }

    protected void printBaseType(String name, StringBuilder builder) {
        builder.append(name);
    }

    protected void printArrowType(Type left, Type right, StringBuilder builder) {
        if (left.isArrowType()) {
            builder.append("(");
        }
        this.print(left, builder);
        if (left.isArrowType()) {
            builder.append(")");
        }
        builder.append(" ");
        builder.append(this.queryArrowSymbol());
        builder.append(" ");
        this.print(right, builder);
    }

    protected void printProductType(FixedList<Type> elems, StringBuilder builder) {
        builder.append(this.queryTupleOpenBracket() + " ");
        for (int i = 0; i < elems.size(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            this.print(elems.get(i), builder);
        }
        builder.append(" " + this.queryTupleCloseBracket());
    }

    protected String queryArrowSymbol() {
        return "\u2192";
    }

    protected String queryTupleOpenBracket() {
        return "\u2987";
    }

    protected String queryTupleCloseBracket() {
        return "\u2988";
    }
}

