/*
 * Decompiled with CFR 0.152.
 */
package charlie.util;

import charlie.util.NullStorageException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;

public class FixedList<T>
implements Iterable<T> {
    private final ArrayList<T> _mylist;

    private FixedList(ArrayList<T> lst) {
        this._mylist = lst;
    }

    public static <T> FixedList<T> copy(Collection<T> args) {
        if (args == null) {
            throw new NullStorageException("FixedList", "list to be copied");
        }
        ArrayList<T> result = new ArrayList<T>(args.size());
        for (T x : args) {
            if (x == null) {
                throw new NullStorageException("FixedList", "element in copy constructor");
            }
            result.add(x);
        }
        return new FixedList(result);
    }

    public static <T> FixedList<T> of() {
        return new FixedList(new ArrayList(0));
    }

    public static <T> FixedList<T> of(T arg1) {
        ArrayList<T> result = new ArrayList<T>(1);
        if (arg1 == null) {
            throw new NullStorageException("FixedList", "element in unary constructor");
        }
        result.add(arg1);
        return new FixedList(result);
    }

    public static <T> FixedList<T> of(T arg1, T arg2) {
        ArrayList<T> result = new ArrayList<T>(2);
        if (arg1 == null) {
            throw new NullStorageException("FixedList", "element 1 in binary constructor");
        }
        if (arg2 == null) {
            throw new NullStorageException("FixedList", "element 2 in binary constructor");
        }
        result.add(arg1);
        result.add(arg2);
        return new FixedList(result);
    }

    @SafeVarargs
    public static <T> FixedList<T> of(T ... args) {
        ArrayList<T> result = new ArrayList<T>(args.length);
        for (T x : args) {
            if (x == null) {
                throw new NullStorageException("FixedList", "element in of constructor");
            }
            result.add(x);
        }
        return new FixedList(result);
    }

    public boolean equals(FixedList<T> other) {
        return this._mylist.equals(other._mylist);
    }

    public boolean equals(List<T> other) {
        return this._mylist.equals(other);
    }

    public T get(int index) {
        return this._mylist.get(index);
    }

    public int hashCode() {
        return this._mylist.hashCode();
    }

    public boolean isEmpty() {
        return this._mylist.isEmpty();
    }

    public boolean contains(T elem) {
        return this._mylist.contains(elem);
    }

    public int size() {
        return this._mylist.size();
    }

    public Stream<T> parallelStream() {
        return this._mylist.parallelStream();
    }

    public Stream<T> stream() {
        return this._mylist.stream();
    }

    public FixedList<T> append(FixedList<T> other) {
        return this.append((T)other._mylist);
    }

    public HashSet<T> toSet() {
        return new HashSet<T>(this._mylist);
    }

    public String toString() {
        return this._mylist.toString();
    }

    public FixedList<T> append(List<T> other) {
        ArrayList<T> arr = new ArrayList<T>(this._mylist);
        arr.addAll(other);
        return new FixedList<T>(arr);
    }

    public FixedList<T> append(T other) {
        ArrayList<T> arr = new ArrayList<T>(this._mylist);
        arr.add(other);
        return new FixedList<T>(arr);
    }

    @Override
    public Iterator<T> iterator() {
        return new ImmutableIterator<T>(this, this._mylist.iterator());
    }

    private class ImmutableIterator<T>
    implements Iterator<T> {
        Iterator<T> _mine;

        private ImmutableIterator(FixedList fixedList, Iterator<T> mine) {
            this._mine = mine;
        }

        @Override
        public boolean hasNext() {
            return this._mine.hasNext();
        }

        @Override
        public T next() {
            return this._mine.next();
        }
    }

    public static class Builder<T> {
        private ArrayList<T> _internal;

        public Builder() {
            this._internal = new ArrayList();
        }

        public Builder(int expectedSize) {
            this._internal = new ArrayList(expectedSize);
        }

        public void add(T element) {
            if (this._internal == null) {
                throw new RuntimeException("Using builder that was already built!");
            }
            if (element == null) {
                throw new NullStorageException("FixedList", "element in builder");
            }
            this._internal.add(element);
        }

        public FixedList<T> build() {
            FixedList<T> ret = new FixedList<T>(this._internal);
            this._internal = null;
            return ret;
        }
    }
}

