/*
 * Decompiled with CFR 0.152.
 */
package charlie.util;

import charlie.util.NullStorageException;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;

public class FixedSet<T>
implements Iterable<T> {
    private final Set<T> _myset;

    private FixedSet(Set<T> set) {
        this._myset = set;
    }

    public static <T> FixedSet<T> copy(Set<T> args) {
        if (args == null) {
            throw new NullStorageException("FixedSet", "set to be copied");
        }
        AbstractSet ret = args instanceof TreeSet ? new TreeSet() : new HashSet();
        for (T x : args) {
            if (x == null) {
                throw new NullStorageException("FixedSet", "element in copy constructor");
            }
            ret.add(x);
        }
        return new FixedSet(ret);
    }

    public static <T> FixedSet<T> of() {
        return new FixedSet(Set.of());
    }

    public static <T> FixedSet<T> of(T arg1) {
        if (arg1 == null) {
            throw new NullStorageException("FixedSet", "element in unary constructor");
        }
        return new FixedSet<T>(Set.of(arg1));
    }

    public static <T> FixedSet<T> of(T arg1, T arg2) {
        if (arg1 == null) {
            throw new NullStorageException("FixedSet", "element 1 in biary constructor");
        }
        if (arg2 == null) {
            throw new NullStorageException("FixedSet", "element 2 in biary constructor");
        }
        return new FixedSet<T>(Set.of(arg1, arg2));
    }

    @SafeVarargs
    public static <T> FixedSet<T> of(T ... args) {
        HashSet<T> result = new HashSet<T>(args.length);
        for (T x : args) {
            if (x == null) {
                throw new NullStorageException("FixedSet", "element in of constructor");
            }
            result.add(x);
        }
        return new FixedSet(result);
    }

    public boolean equals(FixedSet<T> other) {
        return this._myset.equals(other._myset);
    }

    public boolean equals(Set<T> other) {
        return this._myset.equals(other);
    }

    public boolean contains(T element) {
        return this._myset.contains(element);
    }

    public int hashCode() {
        return this._myset.hashCode();
    }

    public boolean isEmpty() {
        return this._myset.isEmpty();
    }

    public Stream<T> parallelStream() {
        return this._myset.parallelStream();
    }

    public int size() {
        return this._myset.size();
    }

    public Stream<T> stream() {
        return this._myset.stream();
    }

    public String toString() {
        return this._myset.toString();
    }

    public FixedSet<T> add(T element) {
        AbstractSet ret = this._myset instanceof TreeSet ? new TreeSet<T>(this._myset) : new HashSet<T>(this._myset);
        ret.add(element);
        return new FixedSet<T>(ret);
    }

    @Override
    public Iterator<T> iterator() {
        return new ImmutableIterator<T>(this, this._myset.iterator());
    }

    public static <T> Builder<T> treeBuilder() {
        return new Builder(new TreeSet());
    }

    public static <T> Builder<T> hashBuilder(int expectedSize) {
        return new Builder(new HashSet(expectedSize));
    }

    private class ImmutableIterator<T>
    implements Iterator<T> {
        Iterator<T> _mine;

        private ImmutableIterator(FixedSet fixedSet, Iterator<T> mine) {
            this._mine = mine;
        }

        @Override
        public boolean hasNext() {
            return this._mine.hasNext();
        }

        @Override
        public T next() {
            return this._mine.next();
        }
    }

    public static class Builder<T> {
        private Set<T> _internal;

        private Builder(Set<T> internal) {
            this._internal = internal;
        }

        public void add(T element) {
            if (this._internal == null) {
                throw new RuntimeException("Using builder that was already built!");
            }
            if (element == null) {
                throw new NullStorageException("FixedSet", "element in builder");
            }
            this._internal.add(element);
        }

        public FixedSet<T> build() {
            FixedSet<T> ret = new FixedSet<T>(this._internal);
            this._internal = null;
            return ret;
        }
    }
}

