/*
 * Decompiled with CFR 0.152.
 */
package charlie.util;

import charlie.util.SystemUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class ProcessCaller {
    private final int _timeout;
    private final ProcessBuilder _processBuilder;

    public ProcessCaller(List<String> cmd, int timeout) {
        this._timeout = timeout;
        List<String> systemCommands = ProcessCaller.callSystemBash();
        systemCommands.addAll(cmd);
        this._processBuilder = new ProcessBuilder(systemCommands);
        this._processBuilder.redirectErrorStream(true);
    }

    private Process callProcess() throws IOException, InterruptedException {
        Process process = null;
        process = this._processBuilder.start();
        boolean exited = process.waitFor(this._timeout, TimeUnit.SECONDS);
        if (!exited) {
            process.destroy();
            return null;
        }
        return process;
    }

    public Optional<InputStream> getResultAsInputStream() throws IOException, InterruptedException {
        Process process = this.callProcess();
        if (process == null) {
            return Optional.empty();
        }
        return Optional.of(process.getInputStream());
    }

    public Optional<String> getResultAsString() throws IOException, InterruptedException, ExecutionException {
        Process process = this.callProcess();
        if (process == null) {
            return Optional.empty();
        }
        process.onExit().get();
        String processResult = ProcessCaller.bufferToString(process.getInputStream());
        return Optional.of(processResult);
    }

    private static String bufferToString(InputStream inputStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        return reader.lines().collect(Collectors.joining(System.lineSeparator()));
    }

    static List<String> callSystemBash() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return new ArrayList<String>(List.of("Powershell", "-Command"));
        }
        if (SystemUtils.IS_UNIX_LIKE) {
            return new ArrayList<String>(List.of("/bin/sh", "-c"));
        }
        return List.of();
    }

    public static String callSystemEcho(String echoString) {
        if (SystemUtils.IS_OS_WINDOWS) {
            return "Write-Output '" + echoString + "'";
        }
        if (SystemUtils.IS_UNIX_LIKE) {
            return "echo \"" + echoString + "\"";
        }
        return echoString;
    }
}

