/*
 * Decompiled with CFR 0.152.
 */
package charlie.util;

import java.util.Optional;

public class SystemUtils {
    private static final String WIN_NAME_PREFIX = "Windows";
    private static final String OS_NAME = System.getProperty("os.name");
    private static final String OS_VERSION = System.getProperty("os.version");
    public static final boolean IS_OS_LINUX = SystemUtils.checkOSName(OS_NAME, "Linux") || SystemUtils.checkOSName(OS_NAME, "LINUX");
    public static final boolean IS_OS_MAC = SystemUtils.checkOSName(OS_NAME, "Mac") || SystemUtils.checkOSName(OS_NAME, "MAC");
    public static final boolean IS_OS_WINDOWS = SystemUtils.checkOSName(OS_NAME, "Windows 10") || SystemUtils.checkOSName(OS_NAME, "Windows 11");
    public static boolean IS_UNIX_LIKE = IS_OS_LINUX || IS_OS_MAC;

    static boolean checkOSName(String osName, String osNamePrefix) {
        if (osName == null || osName.isEmpty()) {
            return false;
        }
        return osName.startsWith(osNamePrefix);
    }

    static boolean checkOSVersion(String osVersion, String osVersionPrefix) {
        if (osVersion == null || osVersion.isEmpty()) {
            return false;
        }
        String[] versionPrefixParts = osVersionPrefix.split("\\.");
        String[] versionParts = osVersion.split("\\.");
        for (int i = 0; i < Math.min(versionPrefixParts.length, versionParts.length); ++i) {
            if (versionPrefixParts[i].equals(versionParts[i])) continue;
            return false;
        }
        return true;
    }

    static boolean checkOS(String osName, String osVersion, String osNamePrefix, String osVersionPrefix) {
        if (osName == null || osName.isEmpty() || osVersion == null || osVersion.isEmpty()) {
            return false;
        }
        return SystemUtils.checkOSName(osName, osNamePrefix) && SystemUtils.checkOSVersion(osNamePrefix, osVersionPrefix);
    }

    public static boolean isOSSupported() {
        return IS_OS_LINUX || IS_OS_MAC || IS_OS_WINDOWS;
    }

    public static Optional<SUPPORTED_OS> getCurrentOS() {
        if (IS_OS_LINUX) {
            return Optional.of(SUPPORTED_OS.LINUX);
        }
        if (IS_OS_MAC) {
            return Optional.of(SUPPORTED_OS.MAC);
        }
        if (IS_OS_WINDOWS) {
            return Optional.of(SUPPORTED_OS.WINDOWS);
        }
        return Optional.empty();
    }

    public static enum SUPPORTED_OS {
        WINDOWS,
        LINUX,
        MAC;

    }
}

