/*
 * Decompiled with CFR 0.152.
 */
package cora;

import charlie.parser.lib.ParsingException;
import charlie.reader.AriInputReader;
import charlie.reader.CoraInputReader;
import charlie.reader.ITrsInputReader;
import charlie.reader.OCocoInputReader;
import charlie.smt.IVar;
import charlie.smt.IntegerExpression;
import charlie.smt.SmtFactory;
import charlie.smt.SmtProblem;
import charlie.smt.SmtSolver;
import charlie.smt.Valuation;
import charlie.terms.Term;
import charlie.trs.TRS;
import cora.Parameters;
import cora.config.Settings;
import cora.io.OutputModule;
import cora.io.ProofObject;
import cora.reduction.Reducer;
import cora.rwinduction.InteractiveRewritingInducter;
import cora.termination.TerminationHandler;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;

public class App {
    public static void main(String[] args) {
        try {
            Parameters parameters = new Parameters(args);
            parameters.setupSettings();
            Parameters.Request req = parameters.queryRequest();
            TRS trs = App.readTRS(parameters.querySingleFile());
            OutputModule om = parameters.queryOutputModule(trs);
            App.testSmtSolver();
            ProofObject pobject = App.executeRequest(req, trs, parameters.queryModuleInput(), om);
            if (pobject == null) {
                System.exit(1);
            }
            System.out.println(pobject.printAnswer());
            pobject.justify(om);
            om.printToStdout();
        }
        catch (Parameters.WrongParametersException e) {
            System.out.println(e.getMessage());
            System.exit(0);
        }
        catch (Exception e) {
            System.out.println("Encountered an error:\n" + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
        catch (Error e) {
            System.out.println("Encountered an error:\n" + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static TRS readTRS(String file) {
        try {
            return App.readInput(file);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
        catch (ParsingException e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
        return null;
    }

    public static TRS readInput(String file) throws IOException {
        String extension = App.getExtension(file);
        if (extension.equals("trs")) {
            return OCocoInputReader.readTrsFromFile(file);
        }
        if (extension.equals("itrs")) {
            return ITrsInputReader.readTrsFromFile(file);
        }
        if (extension.equals("ari")) {
            return AriInputReader.readTrsFromFile(file);
        }
        return CoraInputReader.readTrsFromFile(file);
    }

    private static String getExtension(String filename) {
        int i = filename.lastIndexOf(46);
        if (i >= 0) {
            return filename.substring(i + 1).toLowerCase();
        }
        return "";
    }

    private static void testSmtSolver() {
        SmtProblem problem = new SmtProblem();
        IVar x = problem.createIntegerVariable("x");
        problem.require(SmtFactory.createEqual(SmtFactory.createMultiplication(3, (IntegerExpression)x), SmtFactory.createValue(9)));
        SmtSolver.Answer answer = Settings.smtSolver.checkSatisfiability(problem);
        Objects.requireNonNull(answer);
        SmtSolver.Answer answer2 = answer;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SmtSolver.Answer.YES.class, SmtSolver.Answer.NO.class, SmtSolver.Answer.MAYBE.class}, (Object)answer2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Valuation valuation;
                SmtSolver.Answer.YES yES = (SmtSolver.Answer.YES)answer2;
                Valuation val = valuation = yES.val();
                return;
            }
            case 1: {
                SmtSolver.Answer.NO nO = (SmtSolver.Answer.NO)answer2;
                System.out.println("WARNING: the SMT-solver has very unexpected behaviour, claiming that there is no solution for the problem x * 3 = 9.");
                return;
            }
            case 2: 
        }
        SmtSolver.Answer.MAYBE mAYBE = (SmtSolver.Answer.MAYBE)answer2;
        try {
            String string;
            String reason = string = mAYBE.reason();
            System.out.println("WARNING: the SMT-solver does not appear to be set up correctly.  Asking for a solution for the very simple problem [x * 3 = 9] yields the error [" + reason + "].");
            System.out.println("You can manually set an SMT-solver by invoking Cora with the parameter --solver (invoke cora without arguments for further instructions).");
            System.out.println();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    private static ProofObject executeRequest(Parameters.Request request, final TRS trs, List<String> moduleInput, OutputModule output) {
        return switch (request) {
            default -> throw new MatchException(null, null);
            case Parameters.Request.Computability -> TerminationHandler.proveComputability(trs);
            case Parameters.Request.Print -> new ProofObject(){

                @Override
                public ProofObject.Answer queryAnswer() {
                    return ProofObject.Answer.YES;
                }

                @Override
                public String printAnswer() {
                    return "";
                }

                @Override
                public void justify(OutputModule o) {
                    o.printTrs(trs);
                }
            };
            case Parameters.Request.Termination -> TerminationHandler.proveTermination(trs);
            case Parameters.Request.Reduce -> App.executeReduce(trs, moduleInput);
            case Parameters.Request.Equivalence -> InteractiveRewritingInducter.run(trs, moduleInput, output.queryStyle());
        };
    }

    private static ProofObject executeReduce(TRS trs, List<String> moduleInput) {
        Term start;
        if (moduleInput.size() != 1) {
            throw new RuntimeException("Parameters did not supply an input term!");
        }
        String txt = moduleInput.get(0);
        try {
            start = CoraInputReader.readTerm(txt, trs);
        }
        catch (ParsingException e) {
            System.out.println("Exception reading input term " + txt + ":\n" + e.getMessage());
            return null;
        }
        Reducer reducer = new Reducer(trs);
        return reducer.normalise(start);
    }
}

