/*
 * Decompiled with CFR 0.152.
 */
package cora;

import charlie.smt.SmtSolver;
import charlie.solvesmt.ExternalSmtSolver;
import charlie.solvesmt.ProcessSmtSolver;
import charlie.trs.TRS;
import cora.config.Settings;
import cora.io.OutputModule;
import cora.termination.dependency_pairs.DPFramework;
import cora.termination.dependency_pairs.processors.ChainingProcessor;
import cora.termination.dependency_pairs.processors.IntegerMappingProcessor;
import cora.termination.dependency_pairs.processors.SplittingProcessor;
import cora.termination.dependency_pairs.processors.SubtermProcessor;
import cora.termination.dependency_pairs.processors.TheoryArgumentsProcessor;
import cora.termination.dependency_pairs.processors.UsableRulesProcessor;
import cora.termination.dependency_pairs.processors.graph.GraphProcessor;
import cora.termination.dependency_pairs.processors.graph.ReachabilityProcessor;
import cora.termination.dependency_pairs.processors.redpair.ReductionPairProcessor;
import cora.termination.dependency_pairs.processors.redpair.URWrtRedPairProcessor;
import cora.termination.reduction_pairs.horpo.Horpo;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class Parameters {
    private ArrayList<String> _files = new ArrayList();
    private ArrayList<String> _input = new ArrayList();
    private TreeSet<String> _disable = new TreeSet();
    private Settings.Strategy _strategy = null;
    private OutputModule.Style _style = null;
    private Request _request = null;
    private SmtSolver _solver;

    private static TreeMap<String, String> disableableTechniques() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Parameters.addTechnique(map, DPFramework.queryDisabledCode(), "static dependency pairs");
        Parameters.addTechnique(map, DPFramework.queryPrivateDisabledCode(), "consideration of public/private function symbols");
        Parameters.addTechnique(map, GraphProcessor.queryDisabledCode(), "the dependency graph processor");
        Parameters.addTechnique(map, ReachabilityProcessor.queryDisabledCode(), "the reachability processor");
        Parameters.addTechnique(map, ReductionPairProcessor.queryDisabledCode(), "the reduction pair processor");
        Parameters.addTechnique(map, URWrtRedPairProcessor.queryDisabledCode(), "the usable rules with respect to a reduction pair processor");
        Parameters.addTechnique(map, UsableRulesProcessor.queryDisabledCode(), "the usable rules processor");
        Parameters.addTechnique(map, IntegerMappingProcessor.queryDisabledCode(), "the integer mapping processor");
        Parameters.addTechnique(map, ChainingProcessor.queryDisabledCode(), "the chaining processor");
        Parameters.addTechnique(map, SplittingProcessor.queryDisabledCode(), "the constraint modification processor");
        Parameters.addTechnique(map, SubtermProcessor.queryDisabledCode(), "the subterm criterion processor");
        Parameters.addTechnique(map, TheoryArgumentsProcessor.queryDisabledCode(), "the theory arguments processor");
        Parameters.addTechnique(map, Horpo.queryDisabledCode(), "the reduction pair (Constrained) HORPO");
        return map;
    }

    private static void addTechnique(TreeMap<String, String> map, String value, String description) {
        if (map.containsKey(value)) {
            throw new RuntimeException("Disable value " + value + " is used by more than one technique!");
        }
        map.put(value, description);
    }

    public Parameters(String[] args) {
        int i = 0;
        while (i < args.length) {
            i = this.handleArgument(args, i);
        }
        if (this._request == null) {
            this._request = Request.Termination;
        }
    }

    private int handleArgument(String[] args, int index) {
        String arg;
        switch (arg = args[index]) {
            case "-c": 
            case "--computability": {
                this.setRequest(Request.Computability);
                return index + 1;
            }
            case "-d": 
            case "--disable": {
                if (index + 1 == args.length) {
                    throw new WrongParametersException("Parameter " + arg + " without anything to disable!");
                }
                for (String s : args[index + 1].split(",")) {
                    this._disable.add(s);
                }
                return index + 2;
            }
            case "-e": 
            case "--equivalence": {
                this.setRequest(Request.Equivalence);
                Object equation = "";
                ++index;
                while (index < args.length) {
                    equation = (String)equation + args[index];
                    ++index;
                }
                if (!((String)equation).equals("")) {
                    this._input.add((String)equation);
                }
                return index + 1;
            }
            case "-g": 
            case "--strategy": {
                if (index + 1 == args.length) {
                    throw new WrongParametersException("Parameter " + arg + " without a given strategy!");
                }
                if (this._strategy != null) {
                    throw new WrongParametersException("Received strategy parameter twice!");
                }
                this.setStrategy(args[index + 1]);
                return index + 2;
            }
            case "-p": 
            case "--print": {
                this.setRequest(Request.Print);
                return index + 1;
            }
            case "-r": 
            case "--reduce": {
                this.setRequest(Request.Reduce);
                Object trm = "";
                ++index;
                while (index < args.length) {
                    trm = (String)trm + args[index];
                    ++index;
                }
                if (!((String)trm).equals("")) {
                    this._input.add((String)trm);
                }
                return args.length;
            }
            case "-s": 
            case "--solver": {
                if (index + 1 == args.length) {
                    throw new WrongParametersException("Parameter " + arg + " without given solver!");
                }
                ProcessSmtSolver.PhysicalSolver ps = ProcessSmtSolver.stringToSolver(args[index + 1]);
                if (ps != null) {
                    this._solver = new ProcessSmtSolver(ps);
                } else if (args[index + 1].length() > 10 && args[index + 1].substring(0, 9).equals("external:")) {
                    this._solver = new ExternalSmtSolver(args[index + 1].substring(9));
                } else if (args[index + 1].length() == 8 && args[index + 1].equals("external")) {
                    this._solver = new ExternalSmtSolver();
                }
                if (this._solver == null) {
                    throw new WrongParametersException("Unknown SMT solver: " + args[index + 1] + "!");
                }
                return index + 2;
            }
            case "-t": 
            case "--termination": {
                this.setRequest(Request.Termination);
                return index + 1;
            }
            case "-y": 
            case "--style": {
                if (index + 1 == args.length) {
                    throw new WrongParametersException("Parameter " + arg + " without given style!");
                }
                if (this._style != null) {
                    throw new WrongParametersException("Two style parameters are given.");
                }
                String st = args[index + 1].toLowerCase();
                if (st.equals("plain")) {
                    this._style = OutputModule.Style.Plain;
                } else if (st.equals("unicode")) {
                    this._style = OutputModule.Style.Unicode;
                } else {
                    throw new WrongParametersException("Unknown style: " + args[index + 1]);
                }
                return index + 2;
            }
        }
        if (arg.length() == 0) {
            return index + 1;
        }
        if (arg.charAt(0) == '-') {
            throw new WrongParametersException("Unknown runtime argument: " + arg + ".");
        }
        this._files.add(arg);
        return index + 1;
    }

    private void setRequest(Request req) {
        if (this._request == null) {
            this._request = req;
        } else if (this._request != req) {
            throw new WrongParametersException("Cannot set request both to " + String.valueOf((Object)this._request) + " and to " + String.valueOf((Object)req) + ".");
        }
    }

    private void setStrategy(String strategy) {
        if ((strategy = strategy.toLowerCase()).equals("full")) {
            this._strategy = Settings.Strategy.Full;
        } else if (strategy.equals("innermost")) {
            this._strategy = Settings.Strategy.Innermost;
        } else if (strategy.equals("cbv")) {
            this._strategy = Settings.Strategy.CallByValue;
        } else if (strategy.equals("call-by-value")) {
            this._strategy = Settings.Strategy.CallByValue;
        } else {
            throw new WrongParametersException("Unknown strategy: " + strategy + ".  Supported strategies are full, innermost and cbv (call-by-value).");
        }
    }

    public void setupSettings() {
        TreeMap<String, String> codes = Parameters.disableableTechniques();
        for (String d : this._disable) {
            if (codes.containsKey(d)) continue;
            throw new WrongParametersException("Unknown code for technique to disable: " + d);
        }
        Settings.setDisabled(new TreeSet<String>((SortedSet<String>)this._disable));
        if (this._solver != null) {
            Settings.setSolver(this._solver);
        }
        if (this._strategy != null) {
            Settings.setStrategy(this._strategy);
        }
    }

    public Request queryRequest() {
        return this._request;
    }

    public String querySingleFile() {
        if (this._files.size() == 0) {
            throw new WrongParametersException("No input file given!");
        }
        if (this._files.size() >= 2) {
            throw new WrongParametersException("More than one input file given! (" + this._files.get(0) + " and " + this._files.get(1) + ")");
        }
        return this._files.get(0);
    }

    public List<String> queryFiles() {
        return Collections.unmodifiableList(this._files);
    }

    public List<String> queryModuleInput() {
        return Collections.unmodifiableList(this._input);
    }

    public OutputModule queryOutputModule(TRS trs) {
        OutputModule.Style style = this._style;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"Plain", "Unicode"}, (OutputModule.Style)style, n)) {
            default -> throw new MatchException(null, null);
            case -1 -> OutputModule.createUnicodeModule(trs);
            case 0 -> OutputModule.createPlainModule(trs);
            case 1 -> OutputModule.createUnicodeModule(trs);
        };
    }

    public static String getUsageString() {
        StringBuilder str = new StringBuilder();
        str.append("usage: cora [<options>] <input_file>").append(System.lineSeparator());
        str.append("options:").append(System.lineSeparator());
        str.append("    -p | --print                Print the given TRS on standard output.").append(System.lineSeparator());
        str.append("    -r | --reduce <term>        Parse the given term, and reduce it under the given TRS; no further parameters can be given after this as they will be considered part of the term.").append(System.lineSeparator());
        str.append("    -t | --termination          Try to prove or disprove termination of the given TRS.").append(System.lineSeparator());
        str.append("    -c | --computability        Try to prove or disprove universal computability of the given TRS.").append(System.lineSeparator());
        str.append("    -e | --equivalence <equation> Starts the interactive equivalence prover.").append(System.lineSeparator());
        str.append("    -g | --strategy             Set the given strategy for reduction.  Currently supported strategies are full, innermost and call-by-value (cbv).").append(System.lineSeparator());
        str.append("    -y | --style  <style>       Use the given style for printing; currently supported styles are \"plain\" and \"unicode\".").append(System.lineSeparator());
        str.append("    -d | --disable [<tech>]     Disable the given techniques from being used by Cora.").append(System.lineSeparator());
        str.append("        The following techniques can be disabled:").append(System.lineSeparator());
        for (Map.Entry<String, String> entry : Parameters.disableableTechniques().entrySet()) {
            str.append("            " + entry.getKey() + " : " + entry.getValue()).append(System.lineSeparator());
        }
        str.append("    -s | --solver  [<solver>]   Request the given SMT solver to be used.  Note that this solver should be installed on your local computer.").append(System.lineSeparator());
        str.append("        The following SMT solvers are supported.").append(System.lineSeparator());
        str.append("            z3 | cvc5 | yices2    To use any of those, please install locally.").append(System.lineSeparator());
        str.append("            external:command      This allows a user to specify a command that is invoked, for example, a bash script, that calls an SMT solver in exactly the way you want.").append(System.lineSeparator());
        str.append("            external              This calls the script ./smtsolver or smtsolver.bat, depending on your OS").append(System.lineSeparator());
        return str.toString();
    }

    public static enum Request {
        Print,
        Reduce,
        Termination,
        Computability,
        Equivalence;

    }

    public class WrongParametersException
    extends RuntimeException {
        public WrongParametersException(String reason) {
            super("PARAMETERS ERROR: " + reason + "\n" + Parameters.getUsageString());
        }
    }
}

