/*
 * Decompiled with CFR 0.152.
 */
package cora.confluence;

import charlie.substitution.MutableSubstitution;
import charlie.substitution.Unifier;
import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.TermFactory;
import charlie.terms.TheoryFactory;
import charlie.terms.Variable;
import charlie.terms.position.FinalPos;
import charlie.terms.position.Position;
import charlie.terms.replaceable.Replaceable;
import charlie.theorytranslation.TermAnalyser;
import charlie.trs.Rule;
import charlie.trs.TRS;
import charlie.trs.TrsFactory;
import charlie.trs.TrsProperties;
import charlie.util.FixedList;
import cora.config.Settings;
import cora.confluence.CriticalPeak;
import java.util.Collection;
import java.util.LinkedList;

public class CriticalPeaksFinder {
    private final LinkedList<CriticalPeak> _cps = new LinkedList();
    private boolean _nontrivial;

    private CriticalPeaksFinder(boolean includeNontrivial) {
        this._nontrivial = includeNontrivial;
    }

    private void generateCpForDefinedSymbol(Term subterm, Position position, Rule source, Rule target) {
        Term t;
        Term taLhs = target.queryLeftSide();
        MutableSubstitution subst = Unifier.mgu(taLhs, subterm.queryImmediateHeadSubterm(taLhs.numberArguments()));
        if (subst == null) {
            return;
        }
        for (Variable x : target.queryLVars()) {
            t = subst.getReplacement(x);
            if (t.isValue() || t.isVariable()) continue;
            return;
        }
        for (Variable x : source.queryLVars()) {
            t = subst.getReplacement(x);
            if (t.isValue() || t.isVariable()) continue;
            return;
        }
        Term con = TheoryFactory.createConjunction(subst.substitute(target.queryConstraint()), subst.substitute(source.queryConstraint()));
        TermAnalyser.Result result = TermAnalyser.satisfy(con, Settings.smtSolver);
        if (result instanceof TermAnalyser.Result.NO) {
            return;
        }
        Term lhs = source.queryLeftSide().replaceSubterm(position.append(new FinalPos(subterm.numberArguments() - taLhs.numberArguments())), subst.substitute(target.queryRightSide()));
        Term rhs = subst.substitute(source.queryRightSide());
        if (this._nontrivial && lhs.equals(rhs)) {
            return;
        }
        Term top = subst.substitute(source.queryLeftSide());
        this._cps.add(new CriticalPeak(top, lhs, rhs, con));
    }

    private void generateCriticalPairsForSubterm(Term subterm, Position pos, TRS trs, Rule rule) {
        if (!subterm.isFunctionalTerm()) {
            return;
        }
        FunctionSymbol root = subterm.queryRoot();
        int nargs = subterm.numberArguments();
        if (!pos.isEmpty()) {
            trs.queryRulesForSymbol(root, false).forEach(target -> {
                if (nargs >= target.queryLeftSide().numberArguments()) {
                    this.generateCpForDefinedSymbol(subterm, pos, rule, (Rule)target);
                }
            });
        }
        if (root.isTheorySymbol() && nargs > 0 && subterm.queryType().isBaseType() && subterm.queryArguments().stream().allMatch(t -> t.isValue() || t.isVariable())) {
            Variable z = TermFactory.createVar("_z", subterm.queryType());
            this._cps.add(new CriticalPeak(rule.queryLeftSide(), rule.queryLeftSide().replaceSubterm(pos, z), rule.queryRightSide(), TheoryFactory.createConjunction(TheoryFactory.createEquality(z, subterm), rule.queryConstraint())));
        }
    }

    private void generateCriticalPairsForSelfRootOverlap(Rule renamed, Rule original) {
        if (original.queryRightReplaceablePolicy() == TrsProperties.FreshRight.NONE) {
            return;
        }
        this.generateCpForDefinedSymbol(renamed.queryLeftSide(), new FinalPos(0), renamed, original);
    }

    private void generateCriticalPairsForRootOverlap(Rule rule1, Rule rule2) {
        if (rule1.queryLeftSide().numberArguments() >= rule2.queryLeftSide().numberArguments()) {
            this.generateCpForDefinedSymbol(rule1.queryLeftSide(), new FinalPos(0), rule1, rule2);
        } else {
            this.generateCpForDefinedSymbol(rule2.queryLeftSide(), new FinalPos(0), rule2, rule1);
        }
    }

    private static Rule renameRule(Rule rule) {
        MutableSubstitution subst = new MutableSubstitution();
        for (Replaceable x : rule.queryAllReplaceables()) {
            subst.extend(x, TermFactory.createVar(x.queryName(), x.queryType()));
        }
        return TrsFactory.createRule(subst.substitute(rule.queryLeftSide()), subst.substitute(rule.queryRightSide()), subst.substitute(rule.queryConstraint()));
    }

    public static Collection<CriticalPeak> criticalPeaks(TRS trs, boolean nontrivial) {
        if (!trs.verifyProperties(TrsProperties.Level.APPLICATIVE, TrsProperties.Constrained.YES, TrsProperties.TypeLevel.SIMPLE, TrsProperties.Lhs.PATTERN, TrsProperties.Root.THEORY, TrsProperties.FreshRight.CVARS, new TRS.RuleScheme[0])) {
            throw new IllegalArgumentException("Invalid input TRS.");
        }
        CriticalPeaksFinder finder = new CriticalPeaksFinder(nontrivial);
        FixedList<Rule> trsRul = trs.queryRules();
        int nRules = trsRul.size();
        for (int i = 0; i < nRules; ++i) {
            Rule renamed = CriticalPeaksFinder.renameRule(trsRul.get(i));
            renamed.queryLeftSide().visitSubterms((s, p) -> finder.generateCriticalPairsForSubterm((Term)s, (Position)p, trs, renamed));
            finder.generateCriticalPairsForSelfRootOverlap(renamed, trsRul.get(i));
            for (int j = i + 1; j < nRules; ++j) {
                finder.generateCriticalPairsForRootOverlap(renamed, trsRul.get(j));
            }
        }
        return finder._cps;
    }
}

