/*
 * Decompiled with CFR 0.152.
 */
package cora.data.digraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class Digraph {
    private int _numberOfVertices;
    private int _numberOfEdges;
    private final List<Set<Integer>> _adjacencyList;

    public Digraph(int numberOfVertices) {
        if (numberOfVertices < 0) {
            throw new IllegalArgumentException("instantiating a digraph with negative vertices count");
        }
        this._numberOfVertices = numberOfVertices;
        this._numberOfEdges = 0;
        this._adjacencyList = new ArrayList<Set<Integer>>(this._numberOfEdges);
        for (int i = 0; i < this._numberOfVertices; ++i) {
            this._adjacencyList.add(new TreeSet());
        }
    }

    public int getNumberOfVertices() {
        return this._numberOfVertices;
    }

    public int getNumberOfEdges() {
        return this._numberOfEdges;
    }

    private void validateVertex(int vertex, String method) {
        if (vertex < 0 || vertex >= this._numberOfVertices) {
            throw new IndexOutOfBoundsException("Digraph::" + method + "(" + vertex + ") called; expected a value between 0 and " + (this._numberOfVertices - 1) + ".");
        }
    }

    public void addVertex() {
        ++this._numberOfVertices;
        this._adjacencyList.add(new TreeSet());
    }

    public void addEdge(int originVertex, int destinationVertex) {
        this.validateVertex(originVertex, "addEdge");
        this.validateVertex(destinationVertex, "addEdge");
        Set<Integer> targets = this._adjacencyList.get(originVertex);
        if (!targets.contains(destinationVertex)) {
            targets.add(destinationVertex);
            ++this._numberOfEdges;
        }
    }

    public void removeEdge(int originVertex, int destinationVertex) {
        this.validateVertex(originVertex, "removeEdge");
        this.validateVertex(destinationVertex, "removeEdge");
        Set<Integer> targets = this._adjacencyList.get(originVertex);
        if (targets.contains(destinationVertex)) {
            targets.remove(destinationVertex);
            --this._numberOfEdges;
        }
    }

    public boolean isAdjacent(int originVertex, int destinationVertex) {
        this.validateVertex(originVertex, "isAdjacent");
        this.validateVertex(destinationVertex, "isAdjacent");
        return this._adjacencyList.get(originVertex).contains(destinationVertex);
    }

    public Set<Integer> getNeighbours(int originVertex) {
        this.validateVertex(originVertex, "getNeighbours");
        return Collections.unmodifiableSet(this._adjacencyList.get(originVertex));
    }

    public Digraph getSubgraph(List<Integer> vertices) {
        Digraph subGraph = new Digraph(vertices.size());
        TreeMap<Integer, Integer> newindex = new TreeMap<Integer, Integer>();
        for (int i = 0; i < vertices.size(); ++i) {
            int v = vertices.get(i);
            this.validateVertex(v, "getSubgraph");
            newindex.put(v, i);
        }
        for (int v : vertices) {
            int id = (Integer)newindex.get(v);
            Set<Integer> neighbours = this._adjacencyList.get(v);
            for (int n : neighbours) {
                if (!newindex.containsKey(n)) continue;
                subGraph.addEdge(id, (Integer)newindex.get(n));
            }
        }
        return subGraph;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < this._numberOfVertices; ++i) {
            ret.append(i).append(" |-> ").append(this._adjacencyList.get(i)).append("\n");
        }
        return ret.toString();
    }
}

