/*
 * Decompiled with CFR 0.152.
 */
package cora.data.digraph;

import cora.data.digraph.Digraph;
import java.util.ArrayList;
import java.util.List;

public class Reachability {
    private final boolean[] _isReachable;

    public Reachability(Digraph graph, int source) {
        this._isReachable = new boolean[graph.getNumberOfVertices()];
        this.reachabilitySearch(graph, source);
    }

    public Reachability(Digraph graph, Iterable<Integer> sources) {
        this._isReachable = new boolean[graph.getNumberOfVertices()];
        for (int s : sources) {
            if (this._isReachable[s]) continue;
            this.reachabilitySearch(graph, s);
        }
    }

    private void reachabilitySearch(Digraph graph, int source) {
        this._isReachable[source] = true;
        for (int v : graph.getNeighbours(source)) {
            if (this._isReachable[v]) continue;
            this.reachabilitySearch(graph, v);
        }
    }

    public boolean isReachable(int destination) {
        return this._isReachable[destination];
    }

    public List<Integer> getReachableVertices() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = 0; i < this._isReachable.length; ++i) {
            if (!this._isReachable[i]) continue;
            ret.add(i);
        }
        return ret;
    }

    public String toString() {
        return this.getReachableVertices().toString();
    }
}

