/*
 * Decompiled with CFR 0.152.
 */
package cora.data.digraph;

import cora.data.digraph.Digraph;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class SCC {
    private final boolean[] _visided;
    private final int[] _sccId;
    private final int[] _low;
    private final Stack<Integer> stack;
    private int _pre;
    private int _numberOfSCCs;

    public SCC(Digraph graph) {
        this._visided = new boolean[graph.getNumberOfVertices()];
        this.stack = new Stack();
        this._sccId = new int[graph.getNumberOfVertices()];
        this._low = new int[graph.getNumberOfVertices()];
        for (int i = 0; i < graph.getNumberOfVertices(); ++i) {
            if (this._visided[i]) continue;
            this.sccSearch(graph, i);
        }
    }

    private void sccSearch(Digraph graph, int source) {
        int temp;
        this._visided[source] = true;
        ++this._pre;
        int minValue = this._low[source];
        this.stack.push(source);
        for (int neighbor : graph.getNeighbours(source)) {
            if (!this._visided[neighbor]) {
                this.sccSearch(graph, neighbor);
            }
            if (this._low[neighbor] >= minValue) continue;
            minValue = this._low[neighbor];
        }
        if (minValue < this._low[source]) {
            this._low[source] = minValue;
            return;
        }
        do {
            temp = this.stack.pop();
            this._sccId[temp] = this._numberOfSCCs++;
            this._low[temp] = graph.getNumberOfVertices();
        } while (temp != source);
    }

    private void validateVertex(int vertex, String method) {
        int bound = this._visided.length;
        if (vertex < 0 || vertex > bound - 1) {
            throw new IndexOutOfBoundsException("SCC::" + method + "(" + vertex + ") called; expected a value between 0 and " + (bound - 1) + ".");
        }
    }

    public int getNumberOfSCCs() {
        return this._numberOfSCCs;
    }

    public boolean isStronglyConnected(int source, int destination) {
        this.validateVertex(source, "isStronglyConnected");
        this.validateVertex(destination, "isStronglyConnected");
        return this._sccId[source] == this._sccId[destination];
    }

    public int getSccId(int vertex) {
        this.validateVertex(vertex, "getSccId");
        return this._sccId[vertex];
    }

    public List<List<Integer>> getSccData() {
        ArrayList<List<Integer>> components = new ArrayList<List<Integer>>(this.getNumberOfSCCs());
        for (int i = 0; i < this.getNumberOfSCCs(); ++i) {
            components.add(new ArrayList());
        }
        for (int v = 0; v < this._visided.length; ++v) {
            ((List)components.get(this.getSccId(v))).add(v);
        }
        return components;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        List<List<Integer>> components = this.getSccData();
        for (int i = 0; i < this.getNumberOfSCCs(); ++i) {
            ret.append("Component ").append(i).append(": ").append(components.get(i)).append("\n");
        }
        return ret.toString();
    }
}

