/*
 * Decompiled with CFR 0.152.
 */
package cora.io;

import charlie.printer.Printer;
import charlie.printer.PrinterFactory;
import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.replaceable.MutableRenaming;
import charlie.trs.Rule;
import charlie.trs.TRS;
import cora.io.IllegalPrintException;
import cora.io.PageBuilder;
import cora.io.TextPageBuilder;
import java.util.ArrayList;
import java.util.List;

public class OutputModule {
    private Printer _printer;
    private PageBuilder _page;
    private Style _style;
    private PageBuilder.Table _table;

    public OutputModule(Printer printer, PageBuilder page, Style style) {
        this._printer = printer;
        this._page = page;
        this._style = style;
        this._table = null;
    }

    public OutputModule(TRS trs, PageBuilder page, Style style) {
        this._printer = switch (style.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> PrinterFactory.createPlainPrinter(trs);
            case 1 -> PrinterFactory.createUnicodePrinter(trs);
        };
        this._page = page;
        this._style = style;
        this._table = null;
    }

    public static OutputModule createPlainModule(TRS trs) {
        return new OutputModule(PrinterFactory.createPlainPrinter(trs), (PageBuilder)new TextPageBuilder(), Style.Plain);
    }

    public static OutputModule createUnicodeModule(TRS trs) {
        return new OutputModule(PrinterFactory.createUnicodePrinter(trs), (PageBuilder)new TextPageBuilder(), Style.Unicode);
    }

    public static OutputModule createUnitTestModule() {
        return new OutputModule(PrinterFactory.createPrinterNotForUserOutput(), (PageBuilder)new TextPageBuilder(), Style.Unicode);
    }

    public Style queryStyle() {
        return this._style;
    }

    public Printer queryPrinter() {
        return this._printer;
    }

    public final MutableRenaming generateUniqueNaming(Term ... terms) {
        return this._printer.queryTermPrinter().generateUniqueNaming(terms);
    }

    public final MutableRenaming generateUniqueNaming(List<Term> terms) {
        return this._printer.queryTermPrinter().generateUniqueNaming(terms);
    }

    public boolean queryInParagraph() {
        return this._table == null && !this._printer.isEmpty();
    }

    public void print(String text, Object ... objects) {
        int nextCodeStart;
        ArrayList<Object> parts = new ArrayList<Object>();
        int start = 0;
        int objectIndex = 0;
        while ((nextCodeStart = this.readUntilNextCode(text, start, parts)) != -1) {
            String code = this.readCode(text, nextCodeStart);
            start = nextCodeStart + code.length();
            if (code.equals("%a")) {
                if (objectIndex >= objects.length) {
                    throw new IllegalPrintException("Encountered at least " + (objectIndex + 1) + " occurrences of %a in a print, while only " + objects.length + " objects were given! (Text is " + text + ")");
                }
                parts.add(objects[objectIndex++]);
                continue;
            }
            if (code.equals("%%")) {
                parts.add("%");
                continue;
            }
            parts.add(this.translateCode(code));
        }
        if (objectIndex != objects.length) {
            throw new IllegalPrintException("Encountered only " + objectIndex + " occurrences of %a in a print, while " + objects.length + " objects were given! (Text is " + text + ")");
        }
        this._printer.add(parts);
    }

    private int readUntilNextCode(String text, int start, ArrayList<Object> parts) {
        int ret = text.indexOf(37, start);
        if (ret == -1) {
            parts.add(text.substring(start));
        } else {
            parts.add(text.substring(start, ret));
        }
        return ret;
    }

    private String readCode(String text, int codeStart) {
        if (codeStart < text.length() - 1) {
            int end;
            if (text.charAt(codeStart + 1) == 'a') {
                return "%a";
            }
            if (text.charAt(codeStart + 1) == '%') {
                return "%%";
            }
            if (text.charAt(codeStart + 1) == '{' && (end = text.indexOf(125, codeStart)) != -1) {
                return text.substring(codeStart, end + 1);
            }
        }
        throw new IllegalPrintException("Encountered % in print to OutputModule without a valid code: " + text.substring(codeStart));
    }

    private String translateCode(String code) {
        return switch (code) {
            case "%{ruleArrow}" -> this._printer.symbRuleArrow();
            case "%{typeArrow}" -> this._printer.symbTypeArrow();
            case "%{mapsto}" -> this._printer.symbMapsto();
            case "%{thickArrow}" -> this._printer.symbThickArrow();
            case "%{longArrow}" -> this._printer.symbLongArrow();
            case "%{downArrow}" -> this._printer.symbDownArrow();
            case "%{revRuleArrow}" -> this._printer.symbRevRuleArrow();
            case "%{vdash}" -> this._printer.symbVdash();
            case "%{Vdash}" -> this._printer.symbVDash();
            case "%{forall}" -> this._printer.symbForall();
            case "%{exists}" -> this._printer.symbExists();
            case "%{and}" -> this._printer.symbAnd();
            case "%{or}" -> this._printer.symbOr();
            case "%{not}" -> this._printer.symbNot();
            case "%{implies}" -> this._printer.symbImplies();
            case "%{iff}" -> this._printer.symbIff();
            case "%{emptyset}" -> this._printer.symbEmptySet();
            case "%{union}" -> this._printer.symbUnion();
            case "%{subterm}" -> this._printer.symbSubterm();
            case "%{subtermeq}" -> this._printer.symbSubtermeq();
            case "%{supterm}" -> this._printer.symbSupterm();
            case "%{suptermeq}" -> this._printer.symbSuptermeq();
            case "%{sqSupset}" -> this._printer.symbSqSupset();
            case "%{sqSupseteq}" -> this._printer.symbSqSupseteq();
            case "%{succ}" -> this._printer.symbSucc();
            case "%{succeq}" -> this._printer.symbSucceq();
            case "%{greater}" -> this._printer.symbGreater();
            case "%{smaller}" -> this._printer.symbSmaller();
            case "%{geq}" -> this._printer.symbGeq();
            case "%{leq}" -> this._printer.symbLeq();
            case "%{langle}" -> this._printer.symbLangle();
            case "%{rangle}" -> this._printer.symbRangle();
            case "%{distinct}" -> this._printer.symbDistinct();
            case "%{approx}" -> this._printer.symbApprox();
            case "%{sharp}" -> this._printer.symbSharp();
            case "%{bullet}" -> this._printer.symbBullet();
            case "%{star}" -> this._printer.symbStar();
            case "%{alpha}" -> this._printer.symbAlpha();
            case "%{beta}" -> this._printer.symbBeta();
            case "%{gamma}" -> this._printer.symbGamma();
            case "%{delta}" -> this._printer.symbDelta();
            case "%{epsilon}" -> this._printer.symbEpsilon();
            case "%{zeta}" -> this._printer.symbZeta();
            case "%{eta}" -> this._printer.symbEta();
            case "%{theta}" -> this._printer.symbTheta();
            case "%{iota}" -> this._printer.symbIota();
            case "%{kappa}" -> this._printer.symbKappa();
            case "%{lambda}" -> this._printer.symbLambda();
            case "%{mu}" -> this._printer.symbMu();
            case "%{nu}" -> this._printer.symbNu();
            case "%{xi}" -> this._printer.symbXi();
            case "%{pi}" -> this._printer.symbPi();
            case "%{rho}" -> this._printer.symbRho();
            case "%{sigma}" -> this._printer.symbSigma();
            case "%{tau}" -> this._printer.symbTau();
            case "%{phi}" -> this._printer.symbPhi();
            case "%{chi}" -> this._printer.symbChi();
            case "%{psi}" -> this._printer.symbPsi();
            case "%{omega}" -> this._printer.symbOmega();
            default -> throw new IllegalPrintException("Encountered code " + code + " which is not recognised.");
        };
    }

    public void println() {
        if (this._table != null) {
            if (!this._printer.isEmpty() || !this._table.rowStarted()) {
                this._table.addCell(this._printer.toString());
            }
            this._table.endRow();
        } else {
            this._page.addParagraph(this._printer.toString());
        }
        this._printer.clear();
    }

    public void println(String text, Object ... objects) {
        this.print(text, objects);
        this.println();
    }

    public void startTable() {
        if (this._table != null) {
            this.endTable();
        }
        if (!this._printer.isEmpty()) {
            this.println();
        }
        this._table = new PageBuilder.Table();
    }

    public void nextColumn() {
        if (this._table == null) {
            throw new IllegalPrintException("Called nextColumn when no table was started!");
        }
        this._table.addCell(this._printer.toString());
        this._printer.clear();
    }

    public void nextColumn(String text, Object ... objects) {
        this.print(text, objects);
        this.nextColumn();
    }

    public void endTable() {
        if (this._table == null) {
            throw new IllegalPrintException("Called endTable when no table was started!");
        }
        if (!this._printer.isEmpty()) {
            this._table.addCell(this._printer.toString());
            this._printer.clear();
        }
        this._table.endRow();
        this._page.addTable(this._table);
        this._table = null;
    }

    public void printRules(List<Rule> rules) {
        this.startTable();
        for (Rule rule : rules) {
            this.println("%a", rule);
        }
        this.endTable();
    }

    public void printTrs(TRS trs) {
        this.print("%a with ", trs.queryTrsKind());
        if (trs.querySchemeCount() == 0) {
            this.println("no additional rule schemes:", new Object[0]);
        } else if (trs.querySchemeCount() == 1) {
            this.println("only rule scheme " + String.valueOf((Object)trs.queryScheme(0)) + ":", new Object[0]);
        } else {
            this.print("rule schemes ", new Object[0]);
            for (int i = 0; i < trs.querySchemeCount() - 2; ++i) {
                this.print("%a, ", new Object[]{trs.queryScheme(i)});
            }
            this.print("%a and %a:", trs.queryScheme(trs.querySchemeCount() - 2).toString(), trs.queryScheme(trs.querySchemeCount() - 1).toString());
        }
        this.startTable();
        this.nextColumn("Signature:", new Object[0]);
        boolean printedAny = false;
        for (FunctionSymbol f : trs.queryAlphabet().getSymbols()) {
            if (printedAny) {
                this.nextColumn(" ", new Object[0]);
            } else {
                printedAny = true;
            }
            this.nextColumn("%a", f.queryName());
            this.nextColumn("::", new Object[0]);
            this.nextColumn("%a", f.queryType());
            if (trs.isPrivate(f)) {
                this.nextColumn("(private)", new Object[0]);
            }
            this.println();
        }
        if (!printedAny) {
            this.println("(empty)", new Object[0]);
        }
        this.endTable();
        this.startTable();
        printedAny = false;
        this.nextColumn("Rules:", new Object[0]);
        for (int i = 0; i < trs.queryRuleCount(); ++i) {
            if (printedAny) {
                this.nextColumn(" ", new Object[0]);
            } else {
                printedAny = true;
            }
            this.println("%a", trs.queryRule(i));
        }
        if (!printedAny) {
            this.println("(empty)", new Object[0]);
        }
        this.endTable();
    }

    public void printToStdout() {
        if (this._table != null) {
            this.endTable();
        }
        if (!this._printer.isEmpty()) {
            this.println();
        }
        System.out.print(this._page.toString());
    }

    public String toString() {
        return this._page.toString();
    }

    public static enum Style {
        Plain,
        Unicode;

    }
}

