/*
 * Decompiled with CFR 0.152.
 */
package cora.io;

import java.util.ArrayList;

public interface PageBuilder {
    public void addParagraph(String var1);

    public void addTable(Table var1);

    public static class Table {
        private ArrayList<ArrayList<String>> _cells = new ArrayList();
        private int _numColumns = 0;
        private boolean _rowStarted = false;

        public void addCell(String txt) {
            ArrayList<Object> row;
            if (this._rowStarted) {
                row = this._cells.get(this._cells.size() - 1);
            } else {
                row = new ArrayList();
                this._cells.add(row);
                this._rowStarted = true;
            }
            row.add(txt);
            if (row.size() > this._numColumns) {
                ++this._numColumns;
            }
        }

        public boolean rowStarted() {
            return this._rowStarted;
        }

        public void endRow() {
            this._rowStarted = false;
        }

        public int numRows() {
            return this._cells.size();
        }

        public int numColumns() {
            return this._numColumns;
        }

        public String getCellContents(int rownum, int columnnum) {
            ArrayList<String> row = this._cells.get(rownum);
            if (columnnum >= this._numColumns) {
                throw new IndexOutOfBoundsException("Requested column " + columnnum + " when _numColumns = " + this._numColumns + ".");
            }
            if (columnnum >= row.size()) {
                return "";
            }
            return row.get(columnnum);
        }

        public int getColumnSize(int column) {
            int ret = 0;
            for (ArrayList<String> row : this._cells) {
                int n;
                if (column >= row.size() || (n = row.get(column).length()) <= ret) continue;
                ret = n;
            }
            return ret;
        }

        public ArrayList<Integer> getColumnSizes() {
            ArrayList<Integer> ret = new ArrayList<Integer>(this._numColumns);
            for (int i = 0; i < this._numColumns; ++i) {
                ret.add(this.getColumnSize(i));
            }
            return ret;
        }

        public String toString() {
            StringBuilder ret = new StringBuilder();
            ArrayList<Integer> width = this.getColumnSizes();
            for (ArrayList<String> row : this._cells) {
                ret.append("  ");
                int space = 0;
                for (int x = 0; x < this._numColumns; ++x) {
                    String txt;
                    String string = txt = x >= row.size() ? "" : row.get(x);
                    if (txt.equals("")) {
                        space += width.get(x) + 1;
                        continue;
                    }
                    ret.append(String.format("%" + (space += txt.length()) + "s", txt));
                    space = width.get(x) + 1 - txt.length();
                }
                ret.append("\n");
            }
            return ret.toString();
        }
    }
}

