/*
 * Decompiled with CFR 0.152.
 */
package cora.reduction;

import charlie.substitution.MutableSubstitution;
import charlie.terms.Term;
import charlie.terms.Variable;
import cora.reduction.ReduceObject;
import java.util.ArrayList;

class BetaReducer
implements ReduceObject {
    BetaReducer() {
    }

    @Override
    public boolean applicable(Term t) {
        return t.isBetaRedex();
    }

    @Override
    public Term apply(Term t) {
        Term head = t.queryHead();
        ArrayList<Term> args = t.queryArguments();
        if (!head.isAbstraction() || args.size() < 1) {
            return null;
        }
        Term a = head.queryAbstractionSubterm();
        Variable x = head.queryVariable();
        Term b = (Term)args.get(0);
        MutableSubstitution gamma = new MutableSubstitution();
        gamma.extend(x, b);
        Term newhead = gamma.substitute(a);
        if (args.size() == 1) {
            return newhead;
        }
        return newhead.apply(args.subList(1, args.size()));
    }

    @Override
    public String toString() {
        return "\u03b2 : (\u03bbx.s)(t_0,...,t_n) \u2192 s[x:=t_0](t_1,...,t_n)";
    }
}

