/*
 * Decompiled with CFR 0.152.
 */
package cora.reduction;

import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.theorytranslation.TermAnalyser;
import cora.reduction.ReduceObject;

class CalcReducer
implements ReduceObject {
    CalcReducer() {
    }

    @Override
    public boolean applicable(Term t) {
        if (!t.queryType().isBaseType() || !t.queryType().isTheoryType()) {
            return false;
        }
        if (!t.isFunctionalTerm()) {
            return false;
        }
        FunctionSymbol root = t.queryRoot();
        if (root == null || !root.isTheorySymbol() || root.isValue()) {
            return false;
        }
        for (int i = 1; i <= t.numberArguments(); ++i) {
            if (t.queryArgument(i).isValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Term apply(Term t) {
        if (!t.queryType().isBaseType() || !t.queryType().isTheoryType()) {
            return null;
        }
        if (t.isValue() || !t.isGround() || !t.isTheoryTerm()) {
            return null;
        }
        return TermAnalyser.calculate(t);
    }

    @Override
    public String toString() {
        return "calc : f(x1,...,xk) \u2192 y [f(x1,...,xk) = y] for f \u2208 \u03a3_{theory}";
    }
}

