/*
 * Decompiled with CFR 0.152.
 */
package cora.reduction;

import charlie.terms.Term;
import charlie.terms.TermFactory;
import charlie.terms.Variable;
import cora.reduction.ReduceObject;
import java.util.ArrayList;
import java.util.List;

class EtaReducer
implements ReduceObject {
    EtaReducer() {
    }

    @Override
    public boolean applicable(Term t) {
        Term s = t.queryHead();
        if (!s.isAbstraction()) {
            return false;
        }
        Variable x = s.queryVariable();
        Term main = s.queryAbstractionSubterm();
        ArrayList<Term> parts = main.queryArguments();
        if (parts.size() == 0) {
            return false;
        }
        if (!((Term)parts.get(parts.size() - 1)).equals(x)) {
            return false;
        }
        if (main.queryHead().vars().contains(x)) {
            return false;
        }
        for (int i = 0; i < parts.size() - 1; ++i) {
            if (!((Term)parts.get(i)).vars().contains(x)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Term apply(Term t) {
        Term s = t.queryHead();
        if (!s.isAbstraction()) {
            return null;
        }
        Variable x = s.queryVariable();
        Term main = s.queryAbstractionSubterm();
        Term head = main.queryHead();
        List<Term> args = main.queryArguments();
        if (args.size() == 0 || !((Term)args.get(args.size() - 1)).equals(x)) {
            return null;
        }
        Term ret = TermFactory.createApp(head, args = args.subList(0, args.size() - 1));
        if (ret.vars().contains(x)) {
            return null;
        }
        args = t.queryArguments();
        if (args.size() > 0) {
            ret = TermFactory.createApp(ret, args);
        }
        return ret;
    }

    @Override
    public String toString() {
        return "\u03b7 : \u03bbx.s x \u2192 x if x \u2209 FV(s)";
    }
}

