/*
 * Decompiled with CFR 0.152.
 */
package cora.reduction;

import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.Variable;
import charlie.terms.position.Position;
import charlie.trs.Rule;
import charlie.trs.TRS;
import charlie.util.Pair;
import cora.config.Settings;
import cora.reduction.BetaReducer;
import cora.reduction.CalcReducer;
import cora.reduction.EtaReducer;
import cora.reduction.ReduceObject;
import cora.reduction.Reduction;
import cora.reduction.RuleReducer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class Reducer {
    private ArrayList<ReduceObject> _components = new ArrayList();
    private TreeMap<FunctionSymbol, Integer> _arity = new TreeMap();

    public Reducer(TRS trs) {
        int i;
        block5: for (i = 0; i < trs.querySchemeCount(); ++i) {
            switch (trs.queryScheme(i)) {
                case Eta: {
                    this._components.add(new EtaReducer());
                    continue block5;
                }
                case Beta: {
                    this._components.add(new BetaReducer());
                    continue block5;
                }
                case Calc: {
                    this._components.add(new CalcReducer());
                }
            }
        }
        for (i = 0; i < trs.queryRuleCount(); ++i) {
            Rule rule = trs.queryRule(i);
            this._components.add(new RuleReducer(rule));
            if (!rule.queryLeftSide().isFunctionalTerm()) {
                this._arity = null;
                break;
            }
            FunctionSymbol f = rule.queryLeftSide().queryRoot();
            int k = rule.queryLeftSide().numberArguments();
            if (this._arity.containsKey(f) && this._arity.get(f) <= k) continue;
            this._arity.put(f, k);
        }
    }

    public Position leftmostInnermostRedexPosition(Term s) {
        Pair<Term, Position> p = s.findSubterm((sub, pos) -> {
            for (int j = 0; j < this._components.size(); ++j) {
                if (!this._components.get(j).applicable((Term)sub)) continue;
                return true;
            }
            return false;
        });
        if (p == null) {
            return null;
        }
        return p.snd();
    }

    private boolean hasBinder(Term t) {
        for (Variable x : t.vars()) {
            if (!x.isBinderVariable()) continue;
            return true;
        }
        return false;
    }

    private boolean cbvReductionOK(Term t) {
        if (this.hasBinder(t)) {
            return false;
        }
        if (this._arity == null) {
            return true;
        }
        LinkedList<Term> parts = new LinkedList<Term>();
        for (int i = 1; i <= t.numberArguments(); ++i) {
            parts.add(t.queryArgument(i));
        }
        while (!parts.isEmpty()) {
            Term sub = (Term)parts.pop();
            if (sub.isVariable() || sub.isValue()) continue;
            for (int i = 1; i <= sub.numberArguments(); ++i) {
                parts.add(sub.queryArgument(i));
            }
            if (sub.isAbstraction() || this.hasBinder(sub)) continue;
            if (!sub.isFunctionalTerm()) {
                return false;
            }
            FunctionSymbol root = sub.queryRoot();
            if (!(root.isTheorySymbol() ? !root.queryType().isArrowType() : this._arity.containsKey(root) && sub.numberArguments() >= this._arity.get(root))) continue;
            return false;
        }
        return true;
    }

    public Term reduce(Term s) {
        Collections.shuffle(this._components);
        List<Pair<Term, Position>> subterms = s.querySubterms();
        switch (Settings.queryRewritingStrategy()) {
            case Full: {
                Collections.shuffle(subterms);
                break;
            }
            case CallByValue: {
                subterms = subterms.stream().filter(p -> this.cbvReductionOK((Term)p.fst())).collect(Collectors.toList());
                break;
            }
        }
        for (int i = 0; i < subterms.size(); ++i) {
            Term sub = subterms.get(i).fst();
            Position pos = subterms.get(i).snd();
            Term result = null;
            for (int j = 0; j < this._components.size() && result == null; ++j) {
                result = this._components.get(j).apply(sub);
            }
            if (result == null) continue;
            return s.replaceSubterm(pos, result);
        }
        return null;
    }

    public Reduction normalise(Term s) {
        ArrayList<Term> steps = new ArrayList<Term>();
        do {
            steps.add(s);
        } while ((s = this.reduce(s)) != null);
        return new Reduction(steps);
    }
}

