/*
 * Decompiled with CFR 0.152.
 */
package cora.reduction;

import charlie.terms.Term;
import charlie.terms.replaceable.MutableRenaming;
import charlie.util.Pair;
import cora.io.OutputModule;
import cora.io.ProofObject;
import java.util.List;

class Reduction
implements ProofObject {
    private List<Term> _steps;

    Reduction(List<Term> steps) {
        this._steps = steps;
    }

    @Override
    public ProofObject.Answer queryAnswer() {
        return ProofObject.Answer.YES;
    }

    @Override
    public String printAnswer() {
        return "Normalised input term to: " + this._steps.get(this._steps.size() - 1).toString();
    }

    @Override
    public void justify(OutputModule out) {
        MutableRenaming naming = out.generateUniqueNaming(this._steps);
        out.startTable();
        boolean first = true;
        for (Term t : this._steps) {
            out.nextColumn(first ? "" : "%{ruleArrow}", new Object[0]);
            out.println("%a", new Pair<Term, MutableRenaming>(t, naming));
            first = false;
        }
        out.endTable();
    }
}

