/*
 * Decompiled with CFR 0.152.
 */
package cora.reduction;

import charlie.substitution.Matcher;
import charlie.substitution.MutableSubstitution;
import charlie.substitution.Substitution;
import charlie.terms.Term;
import charlie.terms.Variable;
import charlie.theorytranslation.TermAnalyser;
import charlie.trs.Rule;
import charlie.types.Type;
import cora.config.Settings;
import cora.reduction.ReduceObject;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;

class RuleReducer
implements ReduceObject {
    private Rule _rule;

    public RuleReducer(Rule rule) {
        this._rule = rule;
    }

    private int findHeadAdditions(Term t) {
        Type mytype = this._rule.queryType();
        Type histype = t.queryType();
        int k = 0;
        while (mytype.isArrowType() && !mytype.equals(histype)) {
            mytype = mytype.subtype(2);
            ++k;
        }
        if (mytype.equals(histype)) {
            return k;
        }
        return -1;
    }

    @Override
    public boolean applicable(Term t) {
        int n = t.numberArguments();
        int k = this.findHeadAdditions(t);
        if (k == -1 || n < k) {
            return false;
        }
        Term head = t.queryImmediateHeadSubterm(n - k);
        MutableSubstitution subst = Matcher.match(this._rule.queryLeftSide(), head);
        if (subst == null) {
            return false;
        }
        for (Variable x : this._rule.queryConstraint().vars()) {
            if (subst.get(x) == null || subst.get(x).isValue()) continue;
            return false;
        }
        Term csub = subst.substitute(this._rule.queryConstraint());
        if (csub.isGround()) {
            return TermAnalyser.evaluate(csub).getBool();
        }
        return TermAnalyser.satisfy(csub, Settings.smtSolver) instanceof TermAnalyser.Result.YES;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Term apply(Term t) {
        int n = t.numberArguments();
        int k = this.findHeadAdditions(t);
        if (k == -1 || n < k) {
            return null;
        }
        Term head = t.queryImmediateHeadSubterm(n - k);
        MutableSubstitution subst = Matcher.match(this._rule.queryLeftSide(), head);
        if (subst == null) {
            return null;
        }
        for (Variable x : this._rule.queryConstraint().vars()) {
            if (subst.get(x) == null || subst.get(x).isValue()) continue;
            return null;
        }
        Term csub = subst.substitute(this._rule.queryConstraint());
        if (csub.isGround()) {
            if (!TermAnalyser.evaluate(csub).getBool()) {
                return null;
            }
        } else {
            Object result = null;
            TermAnalyser.Result result2 = TermAnalyser.satisfy(csub, Settings.smtSolver);
            Objects.requireNonNull(result2);
            TermAnalyser.Result result3 = result2;
            int n2 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TermAnalyser.Result.NO.class, TermAnalyser.Result.MAYBE.class, TermAnalyser.Result.YES.class}, (Object)result3, n2)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    TermAnalyser.Result.NO nO = (TermAnalyser.Result.NO)result3;
                    return null;
                }
                case 1: {
                    TermAnalyser.Result.MAYBE mAYBE = (TermAnalyser.Result.MAYBE)result3;
                    try {
                        String string;
                        String reason = string = mAYBE.reason();
                        return null;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                case 2: 
            }
            TermAnalyser.Result.YES yES = (TermAnalyser.Result.YES)result3;
            {
                Substitution substitution;
                Substitution gamma = substitution = yES.subst();
                result = gamma;
            }
            for (Variable x : csub.vars()) {
                if (subst.extend(x, result.get(x))) continue;
                return null;
            }
        }
        for (Variable x : this._rule.queryRightSide().vars()) {
            if (subst.get(x) != null) continue;
            subst.extend(x, TermAnalyser.chooseRandomValue(x.queryType()));
        }
        ArrayList<Term> args = new ArrayList<Term>();
        int i = n - k + 1;
        while (true) {
            if (i > n) {
                Term righthead = subst.substitute(this._rule.queryRightSide());
                return righthead.apply(args);
            }
            args.add(t.queryArgument(i));
            ++i;
        }
    }

    @Override
    public String toString() {
        return this._rule.toString();
    }
}

