/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction;

import charlie.parser.lib.ParsingException;
import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.trs.TRS;
import charlie.trs.TrsProperties;
import charlie.types.Type;
import charlie.util.Either;
import charlie.util.FixedList;
import cora.config.Settings;
import cora.io.OutputModule;
import cora.io.PageBuilder;
import cora.io.ProofObject;
import cora.rwinduction.RewritingInductionProof;
import cora.rwinduction.SaveFile;
import cora.rwinduction.command.CmdList;
import cora.rwinduction.command.Command;
import cora.rwinduction.command.CommandAlter;
import cora.rwinduction.command.CommandAuto;
import cora.rwinduction.command.CommandCalc;
import cora.rwinduction.command.CommandCase;
import cora.rwinduction.command.CommandCheck;
import cora.rwinduction.command.CommandContext;
import cora.rwinduction.command.CommandDelete;
import cora.rwinduction.command.CommandDisprove;
import cora.rwinduction.command.CommandEqdelete;
import cora.rwinduction.command.CommandEquations;
import cora.rwinduction.command.CommandGeneralise;
import cora.rwinduction.command.CommandHdelete;
import cora.rwinduction.command.CommandHelp;
import cora.rwinduction.command.CommandHypotheses;
import cora.rwinduction.command.CommandHypothesis;
import cora.rwinduction.command.CommandInduct;
import cora.rwinduction.command.CommandOrdering;
import cora.rwinduction.command.CommandPostulate;
import cora.rwinduction.command.CommandQuit;
import cora.rwinduction.command.CommandRedo;
import cora.rwinduction.command.CommandRules;
import cora.rwinduction.command.CommandSave;
import cora.rwinduction.command.CommandSemiconstructor;
import cora.rwinduction.command.CommandSimplify;
import cora.rwinduction.command.CommandSkip;
import cora.rwinduction.command.CommandSyntax;
import cora.rwinduction.command.CommandUndo;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.PartialProof;
import cora.rwinduction.parser.CommandParsingStatus;
import cora.rwinduction.parser.EquationParser;
import cora.rwinduction.parser.RIParser;
import cora.rwinduction.tui.CacheInputter;
import cora.rwinduction.tui.Inputter;
import cora.rwinduction.tui.OutputPage;
import cora.rwinduction.tui.ReplInputter;
import java.io.File;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;

public class InteractiveRewritingInducter {
    private Inputter _input;
    private OutputModule _output;
    private CmdList _cmdList;
    private PartialProof _proof;

    InteractiveRewritingInducter(Inputter input, OutputModule output, CmdList lst, PartialProof pp) {
        this._input = input;
        this._output = output;
        this._cmdList = lst;
        this._proof = pp;
    }

    private static Either<String, FixedList<EquationContext>> readEquationsOrFile(Inputter inputter, TRS trs) {
        Object eqs = null;
        try {
            String firstInput = inputter.readLine("Please input one or more equations, or a file: ");
            if (firstInput.equals(":quit") || firstInput.equals("")) {
                return null;
            }
            File f = new File(firstInput);
            if (f.exists() && !f.isDirectory()) {
                return new Either.Left<String, FixedList<EquationContext>>(firstInput);
            }
            return new Either.Right<String, FixedList<EquationContext>>(EquationParser.parseEquationList(firstInput, trs));
        }
        catch (Exception e) {
            System.out.println("Invalid input: " + e.getMessage());
            return InteractiveRewritingInducter.readEquationsOrFile(inputter, trs);
        }
    }

    private static CmdList createCmdList(TRS trs) {
        CmdList clst = new CmdList();
        clst.registerEnvironmentCommand(new CommandQuit());
        clst.registerEnvironmentCommand(new CommandSyntax(clst));
        clst.registerEnvironmentCommand(new CommandHelp(clst));
        clst.registerEnvironmentCommand(new CommandRules());
        clst.registerEnvironmentCommand(new CommandEquations());
        clst.registerEnvironmentCommand(new CommandHypotheses());
        clst.registerEnvironmentCommand(new CommandOrdering());
        clst.registerEnvironmentCommand(new CommandSave());
        clst.registerEnvironmentCommand(new CommandCheck());
        clst.registerEnvironmentCommand(new CommandAuto());
        clst.registerEnvironmentCommand(new CommandUndo());
        clst.registerEnvironmentCommand(new CommandRedo());
        clst.registerDeductionCommand(new CommandDelete());
        clst.registerDeductionCommand(new CommandSimplify());
        clst.registerDeductionCommand(new CommandCalc());
        clst.registerDeductionCommand(new CommandCase());
        clst.registerDeductionCommand(new CommandSemiconstructor());
        clst.registerDeductionCommand(new CommandContext());
        clst.registerDeductionCommand(new CommandInduct());
        clst.registerDeductionCommand(new CommandHypothesis());
        clst.registerDeductionCommand(new CommandEqdelete());
        clst.registerDeductionCommand(new CommandHdelete());
        clst.registerDeductionCommand(new CommandAlter());
        clst.registerDeductionCommand(new CommandPostulate());
        clst.registerDeductionCommand(new CommandGeneralise());
        clst.registerDeductionCommand(new CommandSkip());
        clst.registerDeductionCommand(new CommandDisprove());
        return clst;
    }

    /*
     * Loose catch block
     */
    public static ProofObject run(TRS trs, List<String> inputs, OutputModule.Style style) {
        String problem;
        CmdList clst = InteractiveRewritingInducter.createCmdList(trs);
        Inputter inputter = new ReplInputter(clst);
        OutputModule outputter = new OutputModule(trs, (PageBuilder)new OutputPage(), style);
        if (!inputs.isEmpty()) {
            inputter = new CacheInputter(inputs, inputter);
        }
        if ((problem = InteractiveRewritingInducter.checkLegalTrs(trs)) != null) {
            return new ProofObject(){

                @Override
                public ProofObject.Answer queryAnswer() {
                    return ProofObject.Answer.MAYBE;
                }

                @Override
                public void justify(OutputModule module) {
                    module.println(problem, new Object[0]);
                }
            };
        }
        outputter.printTrs(trs);
        Either<String, FixedList<EquationContext>> e = InteractiveRewritingInducter.readEquationsOrFile(inputter, trs);
        PartialProof proof = null;
        if (e != null) {
            Either<String, FixedList<EquationContext>> either = e;
            Objects.requireNonNull(either);
            Either<String, FixedList<EquationContext>> either2 = either;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Either.Left.class, Either.Right.class}, either2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    String string;
                    Either.Left left = (Either.Left)either2;
                    String s = string = (String)left.elem();
                    SaveFile savefile = new SaveFile(s, trs, clst, outputter);
                    proof = savefile.restore();
                    break;
                }
                case 1: {
                    FixedList fixedList;
                    Either.Right right = (Either.Right)either2;
                    FixedList eqs = fixedList = (FixedList)right.elem();
                    proof = new PartialProof(trs, eqs, lst -> outputter.generateUniqueNaming((List<Term>)lst));
                    clst.storeContext(proof, outputter);
                }
            }
        }
        if (proof == null) {
            return new ProofObject(){

                @Override
                public ProofObject.Answer queryAnswer() {
                    return ProofObject.Answer.MAYBE;
                }

                @Override
                public void justify(OutputModule module) {
                    module.println("No valid equations gives.", new Object[0]);
                }
            };
        }
        InteractiveRewritingInducter inducter = new InteractiveRewritingInducter(inputter, outputter, clst, proof);
        return inducter.proveEquivalence();
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    private boolean runCommands(List<String> commands, PartialProof proof, CmdList clst, OutputModule outputter) {
        for (String txt : commands) {
            CommandParsingStatus status = new CommandParsingStatus(txt);
            while (!status.done()) {
                while (status.skipSeparator()) {
                }
                String cmdname = status.nextWord();
                if (cmdname == null) {
                    outputter.println("Illegal input: %a", cmdname);
                    return false;
                }
                Command cmd = this._cmdList.queryCommand(cmdname);
                if (cmd == null) {
                    outputter.println("Unknown command: %a.", cmdname);
                    return false;
                }
                if (!cmd.execute(status)) {
                    return false;
                }
                if (status.commandEnded()) continue;
                int pos = status.currentPosition();
                outputter.println("Unexpected token %a at position %a: expected a semi-colon or the end of the line.", status.nextWord(), pos);
                return false;
            }
        }
        return true;
    }

    private static FixedList<EquationContext> readEquationsFromFile(String filename, TRS trs, OutputModule outputter, ArrayList<String> commands) {
        FixedList.Builder<EquationContext> builder = new FixedList.Builder<EquationContext>();
        boolean readAny = false;
        try {
            Scanner s = new Scanner(new File(filename));
            while (s.hasNextLine()) {
                String line = s.nextLine();
                if (line.length() > 6 && line.substring(0, 6).equals("GOAL E")) {
                    EquationContext goal = InteractiveRewritingInducter.readGoal(line, trs, outputter);
                    if (goal == null) {
                        return null;
                    }
                    builder.add(goal);
                    readAny = true;
                    continue;
                }
                commands.add(line);
            }
            s.close();
        }
        catch (IOException e) {
            outputter.println("Could not read from file: %a.", e.getMessage());
            return null;
        }
        if (!readAny) {
            outputter.println("No goals are given in input file %a.", filename);
            return null;
        }
        return builder.build();
    }

    private static EquationContext readGoal(String line, TRS trs, OutputModule outputter) {
        int k = line.indexOf(58);
        if (k == -1) {
            outputter.println("Illegal input line (not of the form GOAL E<number>: <rest>): %a", line);
            return null;
        }
        int id = -1;
        try {
            id = Integer.parseInt(line.substring(6, k));
        }
        catch (NumberFormatException e) {
            outputter.println("Illegal input line (E is not followed by <integer><colon>): %a", line);
            return null;
        }
        try {
            EquationContext ec = EquationParser.parseEquationContext(line.substring(k + 1), id, trs);
            if (ec != null) {
                return ec;
            }
            outputter.println("Invalid equation context: %a", line);
        }
        catch (ParsingException e) {
            outputter.println("Illegal input line [%a]: %a", line, e.getMessage());
        }
        return null;
    }

    private static String checkLegalTrs(TRS trs) {
        if (!trs.verifyProperties(TrsProperties.Level.META, TrsProperties.Constrained.YES, TrsProperties.TypeLevel.SIMPLEPRODUCTS, TrsProperties.Lhs.SEMIPATTERN, TrsProperties.Root.THEORY, TrsProperties.FreshRight.ANY, new TRS.RuleScheme[0])) {
            return "The TRS does not satisfy the requirements to apply rewriting induction: a simply-typed LCSTRS with left-hand sides being functional terms.";
        }
        String ret = InteractiveRewritingInducter.checkNoIllegalConstructors(trs);
        if (ret == null) {
            ret = InteractiveRewritingInducter.checkConsistentArity(trs);
        }
        if (ret == null) {
            ret = InteractiveRewritingInducter.checkStrategy();
        }
        if (ret != null) {
            return ret;
        }
        return RIParser.checkTrs(trs);
    }

    private static String checkNoIllegalConstructors(TRS trs) {
        for (FunctionSymbol f : trs.queryAlphabet().getSymbols()) {
            Type output;
            if (trs.isDefined(f) || (output = f.queryType().queryOutputType()).isBaseType() && !output.isTheoryType()) continue;
            return "The TRS does not satisfy the requirements of the present implementation: all constructors other than values should have a non-theory sort as output type (this is not the case for " + f.queryName() + ").";
        }
        return null;
    }

    private static String checkConsistentArity(TRS trs) {
        for (FunctionSymbol f : trs.definedSymbols()) {
            if (trs.queryRuleArity(f) != -1) continue;
            return "The TRS does not satisfy the requirements to apply rewriting induction: the function symbol " + f.queryName() + " does not have a consistent arity.";
        }
        return null;
    }

    private static String checkStrategy() {
        switch (Settings.queryRewritingStrategy()) {
            case Full: {
                return null;
            }
            case Innermost: {
                return null;
            }
            case CallByValue: {
                return null;
            }
        }
        return "The reduction strategy is not supported.  Only full, innermost or call-by-value reduction is supported in this module.";
    }

    private ProofObject proveEquivalence() {
        block0: while (!this._proof.isDone()) {
            this.printCurrentState();
            CommandParsingStatus status = new CommandParsingStatus(this._input.readLine());
            while (!status.done()) {
                while (status.skipSeparator()) {
                }
                String cmdname = status.nextWord();
                if (cmdname == null) continue block0;
                Command cmd = this._cmdList.queryCommand(cmdname);
                if (cmd == null) {
                    this._output.println("Unknown command: %a.  Use \":help commands\" to list available commands.", cmdname);
                    continue block0;
                }
                if (this._proof.isFinal() && !cmd.isEnvironmentCommand() && !cmd.queryName().equals("undo")) {
                    this._output.println("As there are no goals left, only environment commands (and undo) can be executed.", new Object[0]);
                    continue block0;
                }
                if (!cmd.execute(status)) continue block0;
                if (status.commandEnded()) continue;
                int pos = status.currentPosition();
                this._output.println("Unexpected token %a at position %a: expected a semi-colon or the end of the line.", status.nextWord(), pos);
                continue block0;
            }
        }
        return new RewritingInductionProof(this._proof);
    }

    private void printCurrentState() {
        if (this._proof.isFinal()) {
            if (this._proof.getProofState().isContradictionState()) {
                this._output.println("A contradiction have been derived!", new Object[0]);
            } else {
                this._output.println("All goals have been successfully removed!", new Object[0]);
            }
            this._output.println("To complete the proof, you still need to verify that a suitable ordering exists.  You can do this using the :check command.  Other useful commands include:", new Object[0]);
            this._output.startTable();
            this._output.println("undo -- to go back to the previous proof state", new Object[0]);
            this._output.println(":quit -- to end the proof process without termination check", new Object[0]);
            this._output.println(":ordering -- to see the current ordering requirements", new Object[0]);
            this._output.println(":rules -- to see the current rules (these must also be oriented)", new Object[0]);
            this._output.println(":check verbose -- to run the termination check and see an elaborate explanation of the outcome (particularly useful if the result is a failure)", new Object[0]);
            this._output.endTable();
        } else {
            this._output.print("%aGoal:%a ", "\u001b[1;34m", "\u001b[0m");
            this._proof.getProofState().getTopEquation().prettyPrint(this._output, true);
            this._output.println();
        }
    }
}

