/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction;

import cora.io.OutputModule;
import cora.io.ProofObject;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.PartialProof;
import cora.rwinduction.engine.ProofState;
import java.util.ArrayList;

public class RewritingInductionProof
implements ProofObject {
    private ArrayList<DeductionStep> _steps;
    private ProofState _finalState;
    private ProofObject _terminationProof;

    public RewritingInductionProof(PartialProof proof) {
        this._finalState = proof.getProofState();
        this._steps = proof.getDeductionHistory();
        this._terminationProof = proof.getTerminationProof();
    }

    @Override
    public ProofObject.Answer queryAnswer() {
        if (this._finalState.isFinalState() && this._terminationProof != null) {
            if (this._finalState.isContradictionState()) {
                return ProofObject.Answer.NO;
            }
            return ProofObject.Answer.YES;
        }
        return ProofObject.Answer.MAYBE;
    }

    @Override
    public void justify(OutputModule module) {
        ProofState start = this._steps.size() == 0 ? this._finalState : this._steps.get(0).getOriginalState();
        module.println("We start the process with the following equations:", new Object[0]);
        this.printEquations(module, start.getEquations());
        for (int i = 0; i < this._steps.size(); ++i) {
            this._steps.get(i).explain(module);
            ProofState curr = this._steps.get(i).getOriginalState();
            ProofState next = i + 1 < this._steps.size() ? this._steps.get(i + 1).getOriginalState() : this._finalState;
            ArrayList<EquationContext> neweqs = this.getNewEquations(next, curr.getLastUsedIndex());
            if (neweqs.size() == 1) {
                module.println("This yields %a", neweqs.get(0));
                continue;
            }
            if (neweqs.size() <= 0) continue;
            module.println("This yields the following new equations:", new Object[0]);
            this.printEquations(module, neweqs);
        }
        if (this._finalState.isFinalState()) {
            String txt = "All equations have been removed, so the proof is complete: the original equations are inductive theorems";
            if (this._finalState.isContradictionState()) {
                txt = "A contradiction has been obtained, so we have seen that the original equations are not all inductive theorems";
            }
            if (this._terminationProof == null || this._terminationProof.queryAnswer() != ProofObject.Answer.YES) {
                module.println(txt + ", provided the underlying ordering requirements can be satisfied.  Unfortunately, the existence of a suitable ordering has not yet been proved.", new Object[0]);
            } else {
                module.println(txt + ".  The existence of a suitable bounding pair is guaranteed by the termination of the corresponding term rewriting systems, as is demonstrated below.", new Object[0]);
                this._terminationProof.justify(module);
            }
        } else {
            module.println("The proof attempt was aborted before a proof could be found.", new Object[0]);
        }
        module.println("Steps:", new Object[0]);
        module.startTable();
        for (int i = 0; i < this._steps.size(); ++i) {
            module.println("%a", this._steps.get(i).commandDescription());
        }
        module.endTable();
    }

    private ArrayList<EquationContext> getNewEquations(ProofState state, int morethan) {
        ArrayList<EquationContext> ret = new ArrayList<EquationContext>();
        for (EquationContext eq : state.getEquations()) {
            if (eq.getIndex() <= morethan) continue;
            ret.add(eq);
        }
        return ret;
    }

    private void printEquations(OutputModule module, Iterable<EquationContext> eqs) {
        module.startTable();
        for (EquationContext eq : eqs) {
            module.println("%a", eq);
        }
        module.endTable();
    }
}

