/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction;

import charlie.parser.lib.ParsingException;
import charlie.terms.Term;
import charlie.trs.TRS;
import charlie.util.FixedList;
import cora.io.OutputModule;
import cora.rwinduction.command.CmdList;
import cora.rwinduction.command.DeductionCommand;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.PartialProof;
import cora.rwinduction.parser.CommandParsingStatus;
import cora.rwinduction.parser.EquationParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class SaveFile {
    private String _filename;
    private TRS _trs;
    private CmdList _cmds;
    private OutputModule _output;

    public SaveFile(String filename, TRS trs, CmdList cmds, OutputModule output) {
        this._filename = filename;
        this._trs = trs;
        this._cmds = cmds;
        this._output = output;
    }

    private FixedList<EquationContext> readEquations(ArrayList<String> commands) {
        FixedList.Builder<EquationContext> builder = new FixedList.Builder<EquationContext>();
        boolean readAny = false;
        try {
            Scanner s = new Scanner(new File(this._filename));
            while (s.hasNextLine()) {
                String line = s.nextLine();
                if (line.length() > 6 && line.substring(0, 6).equals("GOAL E")) {
                    EquationContext goal = this.readGoal(line);
                    if (goal == null) {
                        return null;
                    }
                    builder.add(goal);
                    readAny = true;
                    continue;
                }
                commands.add(line);
            }
            s.close();
        }
        catch (IOException e) {
            this._output.println("Could not read from file %a: %a.", this._filename, e.getMessage());
            return null;
        }
        if (!readAny) {
            this._output.println("No goals are given in input file %a.", this._filename);
            return null;
        }
        return builder.build();
    }

    private EquationContext readGoal(String line) {
        int k = line.indexOf(58);
        if (k == -1) {
            this._output.println("Illegal input line (not of the form GOAL E<number>: <rest>): %a", line);
            return null;
        }
        int id = -1;
        try {
            id = Integer.parseInt(line.substring(6, k));
        }
        catch (NumberFormatException e) {
            this._output.println("Illegal input line (E is not followed by <integer><colon>): %a", line);
            return null;
        }
        try {
            EquationContext ec = EquationParser.parseEquationContext(line.substring(k + 1), id, this._trs);
            if (ec != null) {
                return ec;
            }
            this._output.println("Invalid equation context: %a", line);
        }
        catch (ParsingException e) {
            this._output.println("Illegal input line [%a]: %a", line, e.getMessage());
        }
        return null;
    }

    private boolean runCommand(String str) {
        CommandParsingStatus status = new CommandParsingStatus(str);
        while (!status.done()) {
            String cmdname = status.nextWord();
            if (cmdname == null) {
                this._output.println("Illegal input: %a", str);
                return false;
            }
            DeductionCommand cmd = this._cmds.queryDeductionCommand(cmdname);
            if (cmd == null) {
                this._output.println("Unknown deduction command: %a.", cmdname);
                return false;
            }
            if (!cmd.executeWithoutVerification(status)) {
                return false;
            }
            if (status.done()) continue;
            int pos = status.currentPosition();
            this._output.println("Error parsing command [%a]: unexpected token %a at position %a, where the end of the command was expected.", str, status.nextWord(), pos);
            return false;
        }
        return true;
    }

    public PartialProof restore() {
        ArrayList<String> commands = new ArrayList<String>();
        FixedList<EquationContext> eqs = this.readEquations(commands);
        if (eqs == null) {
            return null;
        }
        PartialProof proof = new PartialProof(this._trs, eqs, lst -> this._output.generateUniqueNaming((List<Term>)lst));
        this._cmds.storeContext(proof, this._output);
        for (String cmd : commands) {
            if (this.runCommand(cmd)) continue;
            return null;
        }
        return proof;
    }
}

