/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.command;

import cora.io.OutputModule;
import cora.rwinduction.command.Command;
import cora.rwinduction.command.DeductionCommand;
import cora.rwinduction.engine.PartialProof;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;

public final class CmdList {
    private TreeSet<String> _originals = new TreeSet();
    private HashMap<String, Command> _commands = new HashMap();
    private HashMap<String, DeductionCommand> _deductionCommands = new HashMap();
    private PartialProof _proof = null;
    private OutputModule _module = null;

    public void registerEnvironmentCommand(Command cmd) {
        String name = cmd.queryName();
        if (this._commands.containsKey(name)) {
            throw new IllegalArgumentException("Double registration of command " + name + ".");
        }
        this._commands.put(cmd.queryName(), cmd);
        this._originals.add(cmd.queryName());
        if (this._proof != null && this._module != null) {
            cmd.storeContext(this._proof, this._module);
        }
    }

    public void registerDeductionCommand(DeductionCommand cmd) {
        String name = cmd.queryName();
        if (this._commands.containsKey(name)) {
            throw new IllegalArgumentException("Double registration of command " + name + ".");
        }
        this._commands.put(cmd.queryName(), cmd);
        this._deductionCommands.put(cmd.queryName(), cmd);
        this._originals.add(cmd.queryName());
        if (this._proof != null && this._module != null) {
            cmd.storeContext(this._proof, this._module);
        }
    }

    public void registerAlias(String alias, String original) {
        if (!this._originals.contains(original)) {
            throw new IllegalArgumentException("Cannot register alias for " + original + " as there is no command by that name defined.");
        }
        if (this._commands.containsKey(alias)) {
            throw new IllegalArgumentException("Double registration of command " + alias + " (as alias).");
        }
        this._commands.put(alias, this._commands.get(original));
        if (this._deductionCommands.containsKey(original)) {
            this._deductionCommands.put(alias, this._deductionCommands.get(original));
        }
    }

    public TreeSet<String> queryCommands() {
        return new TreeSet<String>((SortedSet<String>)this._originals);
    }

    public Command queryCommand(String name) {
        return this._commands.get(name);
    }

    public DeductionCommand queryDeductionCommand(String name) {
        return this._deductionCommands.get(name);
    }

    public void storeContext(PartialProof pp, OutputModule module) {
        for (String name : this._originals) {
            this._commands.get(name).storeContext(pp, module);
        }
        this._proof = pp;
        this._module = module;
    }
}

