/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.command;

import charlie.util.FixedList;
import cora.io.OutputModule;
import cora.rwinduction.engine.PartialProof;
import cora.rwinduction.parser.CommandParsingStatus;
import java.util.List;
import java.util.Optional;

public abstract class Command {
    protected PartialProof _proof;
    protected OutputModule _module;

    protected Command(PartialProof pp, OutputModule om) {
        this._proof = pp;
        this._module = om;
    }

    protected Command() {
        this._proof = null;
        this._module = null;
    }

    public final void storeContext(PartialProof pp, OutputModule om) {
        this._proof = pp;
        this._module = om;
    }

    public abstract String queryName();

    public abstract FixedList<String> callDescriptor();

    public abstract void printHelp(OutputModule var1);

    public abstract List<TabSuggestion> suggestNext(String var1);

    protected final TabSuggestion endOfCommandSuggestion() {
        return new TabSuggestion(null, "end of command");
    }

    public final boolean execute(CommandParsingStatus input) {
        if (this._proof == null || this._module == null) {
            throw new RuntimeException("Command " + this.queryName() + " was called without the context being set!");
        }
        return this.run(input);
    }

    protected abstract boolean run(CommandParsingStatus var1);

    protected final boolean failure(String mess) {
        this._module.println("%a", mess);
        return false;
    }

    protected final boolean verifyEnded(CommandParsingStatus input) {
        if (input.commandEnded()) {
            return true;
        }
        this._module.println("Unexpected argument at position %a: expected end of command.", input.currentPosition());
        return false;
    }

    protected final Optional<OutputModule> optionalModule() {
        return Optional.of(this._module);
    }

    public final boolean isEnvironmentCommand() {
        return this.queryName().charAt(0) == ':';
    }

    public final String toString() {
        return "Command: " + this.queryName();
    }

    public record TabSuggestion(String text, String category) {
    }
}

