/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.command;

import charlie.terms.Term;
import charlie.terms.TermFactory;
import charlie.terms.Variable;
import charlie.terms.replaceable.MutableRenaming;
import charlie.terms.replaceable.Renaming;
import charlie.util.FixedList;
import charlie.util.Pair;
import cora.io.OutputModule;
import cora.rwinduction.command.Command;
import cora.rwinduction.command.DeductionCommand;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.VariableNamer;
import cora.rwinduction.engine.deduction.DeductionAlterConstraint;
import cora.rwinduction.engine.deduction.DeductionAlterDefinitions;
import cora.rwinduction.engine.deduction.DeductionAlterRename;
import cora.rwinduction.parser.CommandParsingStatus;
import java.util.ArrayList;
import java.util.Optional;

public class CommandAlter
extends DeductionCommand {
    @Override
    public String queryName() {
        return "alter";
    }

    @Override
    public FixedList<String> callDescriptor() {
        return FixedList.of("alter add <var> = <term> , ..., <var> = <term>", "alter rename <name> := <newname> , ... , <name> := <newname>", "alter constraint <constraint>");
    }

    @Override
    public void printHelp(OutputModule module) {
        module.println("Use this deduction rule to change an equation to an equivalent one.  For now, we restrict the ways to do this in only specific ways that we know lead to an equivalent constraint without needing to send higher-order constraints into the SMT solver.  More interesting varieties of ALTER may be added in the future.", new Object[0]);
        module.println("For ALTER ADD, all variables that you introduce must be fresh, while the terms may use only variables that already occur in the equation context, or that have been introduced by definition to the left.", new Object[0]);
        module.println("For ALTER RENAME, note that the new names you introduce should not occur in the bounding terms either!", new Object[0]);
        module.println("For ALTER CONSTRAINT, the new constraint should be equivalent to the original one. No fresh variables are allowed to occur in it (but you can add variables that occur only in the body of the equation context, not yet the constraint).", new Object[0]);
    }

    @Override
    protected DeductionStep createStep(CommandParsingStatus input) {
        String action = input.nextWord();
        if (input.commandEnded()) {
            this._module.println("Alter should be invoked with at least two arguments.", new Object[0]);
            return null;
        }
        if (action.equals("add")) {
            return this.createAddStep(input);
        }
        if (action.equals("rename")) {
            return this.createRenameStep(input);
        }
        if (action.equals("constraint")) {
            return this.createConstraintStep(input);
        }
        this._module.println("Unknown action for alter: %a.", action);
        return null;
    }

    DeductionAlterDefinitions createAddStep(CommandParsingStatus input) {
        Optional<OutputModule> om;
        ArrayList<Pair<Pair<Variable, String>, Term>> definitions;
        block5: {
            definitions = new ArrayList<Pair<Pair<Variable, String>, Term>>();
            MutableRenaming renaming = this._proof.getProofState().getTopEquation().getRenaming().copy();
            VariableNamer namer = this._proof.getContext().getVariableNamer();
            om = this.optionalModule();
            do {
                String varname;
                if ((varname = this.readFreshName(input, renaming)) == null) {
                    return null;
                }
                if (!input.expect("=", om)) {
                    return null;
                }
                Term term = input.readTerm(this._proof.getContext().getTRS(), renaming, this._module);
                if (term == null) {
                    return null;
                }
                VariableNamer.VariableInfo info = namer.getVariableInfo(varname);
                Variable x = TermFactory.createVar(info.basename(), term.queryType());
                if (!renaming.setName(x, varname)) {
                    this._module.println("Name %a is not legal for (fresh) variables.", x.queryName());
                    return null;
                }
                Pair<Variable, String> varinfo = new Pair<Variable, String>(x, varname);
                definitions.add(new Pair<Pair<Variable, String>, Term>(varinfo, term));
                if (input.commandEnded()) break block5;
            } while (input.expect(",", om));
            return null;
        }
        return DeductionAlterDefinitions.createStep(this._proof, om, definitions);
    }

    private String readFreshName(CommandParsingStatus input, Renaming renaming) {
        int p = input.currentPosition();
        String varname = input.readIdentifier(Optional.of(this._module), "fresh variable name");
        if (varname == null) {
            return null;
        }
        if (renaming.getReplaceable(varname) != null) {
            this._module.println("Variable %a at position %a is already known in this equation context.  Please choose a fresh name.", varname, input.previousPosition());
            return null;
        }
        return varname;
    }

    DeductionAlterRename createRenameStep(CommandParsingStatus input) {
        Optional<OutputModule> om;
        ArrayList<Pair<String, String>> names;
        block4: {
            names = new ArrayList<Pair<String, String>>();
            om = this.optionalModule();
            do {
                String origname;
                if ((origname = input.readIdentifier(om, "existing variable name")) == null) {
                    return null;
                }
                if (!input.expect(":=", om)) {
                    return null;
                }
                String newname = input.readIdentifier(om, "fresh variable name");
                if (newname == null) {
                    return null;
                }
                names.add(new Pair<String, String>(origname, newname));
                if (input.commandEnded()) break block4;
            } while (input.expect(",", om));
            return null;
        }
        return DeductionAlterRename.createStep(this._proof, om, names);
    }

    DeductionAlterConstraint createConstraintStep(CommandParsingStatus input) {
        Term constraint = input.readTerm(this._proof.getContext().getTRS(), this._proof.getProofState().getTopEquation().getRenaming(), this._module);
        if (constraint == null) {
            return null;
        }
        return DeductionAlterConstraint.createStep(this._proof, this.optionalModule(), constraint);
    }

    public ArrayList<Command.TabSuggestion> suggestNext(String args) {
        ArrayList<Command.TabSuggestion> ret = new ArrayList<Command.TabSuggestion>();
        CommandParsingStatus status = new CommandParsingStatus(args);
        if (status.commandEnded()) {
            ret.add(new Command.TabSuggestion("add", "keyword"));
            ret.add(new Command.TabSuggestion("rename", "keyword"));
            ret.add(new Command.TabSuggestion("constraint", "keyword"));
            return ret;
        }
        String w = status.nextWord();
        if (w.equals("add")) {
            this.addAddSuggestions(status, ret);
        } else if (w.equals("rename")) {
            this.addRenameSuggestions(status, ret);
        } else if (w.equals("constraint")) {
            this.addConstraintSuggestions(status, ret);
        }
        return ret;
    }

    private void addAddSuggestions(CommandParsingStatus status, ArrayList<Command.TabSuggestion> ret) {
        int kind = 1;
        Optional<OutputModule> empty = Optional.empty();
        while (kind > 0 && !status.commandEnded()) {
            if (kind == 1) {
                String name = status.readIdentifier(empty, "identifier");
                if (name == null || name.equals("")) {
                    kind = -1;
                    continue;
                }
                kind = 2;
                continue;
            }
            if (kind == 2) {
                if (status.expect("=", empty)) {
                    kind = 3;
                    continue;
                }
                kind = -1;
                continue;
            }
            if (kind == 3) {
                if (!status.skipTerm()) break;
                kind = 4;
                continue;
            }
            if (status.expect(",", empty)) {
                kind = 1;
                continue;
            }
            status.nextWord();
            kind = -1;
        }
        if (kind == 1) {
            ret.add(new Command.TabSuggestion(null, "variable name"));
        }
        if (kind == 2) {
            ret.add(new Command.TabSuggestion("=", "keyword"));
        }
        if (kind == 3) {
            ret.add(new Command.TabSuggestion(null, "term"));
        }
        if (kind == 4) {
            ret.add(new Command.TabSuggestion(null, "rest of term"));
            ret.add(new Command.TabSuggestion(",", "keyword"));
            ret.add(this.endOfCommandSuggestion());
        }
    }

    private void addRenameSuggestions(CommandParsingStatus status, ArrayList<Command.TabSuggestion> ret) {
        int kind = 1;
        Optional<OutputModule> empty = Optional.empty();
        while (kind > 0 && !status.commandEnded()) {
            if (kind == 1 || kind == 3) {
                String name = status.readIdentifier(empty, "identifier");
                if (name == null || name.equals("")) {
                    kind = -1;
                    continue;
                }
                ++kind;
                continue;
            }
            if (kind == 2) {
                if (status.expect(":=", empty)) {
                    kind = 3;
                    continue;
                }
                kind = -1;
                continue;
            }
            if (status.expect(",", empty)) {
                kind = 1;
                continue;
            }
            status.nextWord();
            kind = -1;
        }
        if (kind == 1) {
            if (this._proof.getProofState().getEquations().isEmpty()) {
                ret.add(new Command.TabSuggestion(null, "existing variable name"));
            } else {
                for (String x : this._proof.getProofState().getTopEquation().getRenaming().range()) {
                    ret.add(new Command.TabSuggestion(x, "existing variable name"));
                }
            }
        }
        if (kind == 2) {
            ret.add(new Command.TabSuggestion(":=", "keyword"));
        }
        if (kind == 3) {
            ret.add(new Command.TabSuggestion(null, "fresh variable name"));
        }
        if (kind == 4) {
            ret.add(new Command.TabSuggestion(",", "keyword"));
            ret.add(this.endOfCommandSuggestion());
        }
    }

    private void addConstraintSuggestions(CommandParsingStatus status, ArrayList<Command.TabSuggestion> ret) {
        if (status.commandEnded()) {
            ret.add(new Command.TabSuggestion(null, "constraint"));
        } else {
            ret.add(new Command.TabSuggestion(null, "rest of constraint"));
            ret.add(this.endOfCommandSuggestion());
        }
    }
}

