/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.command;

import charlie.printer.Printer;
import charlie.printer.PrinterFactory;
import charlie.terms.Term;
import charlie.terms.position.Position;
import charlie.terms.position.PositionFormatException;
import charlie.util.FixedList;
import cora.io.OutputModule;
import cora.rwinduction.command.Command;
import cora.rwinduction.command.DeductionCommand;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.Equation;
import cora.rwinduction.engine.EquationPosition;
import cora.rwinduction.engine.deduction.DeductionCalc;
import cora.rwinduction.engine.deduction.DeductionCalcAll;
import cora.rwinduction.parser.CommandParsingStatus;
import java.util.ArrayList;
import java.util.Optional;

public class CommandCalc
extends DeductionCommand {
    @Override
    public String queryName() {
        return "calc";
    }

    @Override
    public FixedList<String> callDescriptor() {
        return FixedList.of("calc", "calc left", "calc right", "calc <position_1> ... <position_n>");
    }

    @Override
    public void printHelp(OutputModule module) {
        module.println("Use this deduction rule to rewrite the current equation with one or more applications of a calculation step, in some subterm of the left- or right-hand side of the equation.", new Object[0]);
        module.println("Invoking this command without arguments causes all possible calculations to be performed immediately.  Specifying \"left\" or \"right\" does only calculations on the given side.  Alternatively, you can supply one or more positions.", new Object[0]);
        module.println("For each calculatable position, either a value will be computed, or an existing variable in the constraint, or a fresh variable that is then added to the constraint.  Note that, unless you specify positions, the calculations will always be done outermost-first; e.g., x + (y + z) will be replaced by a single variable (defined in the constraint to be x + (y + z)); there will not be variable a = x + b and b = y + z.", new Object[0]);
    }

    @Override
    protected DeductionStep createStep(CommandParsingStatus input) {
        String word = input.nextWord();
        Optional<OutputModule> o = this.optionalModule();
        if (word == null) {
            return DeductionCalcAll.createStep(this._proof, o, DeductionCalcAll.Side.Both);
        }
        if (word.equals("left")) {
            return DeductionCalcAll.createStep(this._proof, o, DeductionCalcAll.Side.Left);
        }
        if (word.equals("right")) {
            return DeductionCalcAll.createStep(this._proof, o, DeductionCalcAll.Side.Right);
        }
        return this.createPositionStep(input, word);
    }

    private DeductionCalc createPositionStep(CommandParsingStatus input, String word) {
        ArrayList<EquationPosition> posses = new ArrayList<EquationPosition>();
        try {
            while (word != null) {
                posses.add(EquationPosition.parse(word));
                word = input.nextWord();
            }
        }
        catch (PositionFormatException e) {
            this._module.println("Illegal position %a (character %a): %a", word, e.queryProblemPos(), e.queryExplanation());
            return null;
        }
        return DeductionCalc.createStep(this._proof, Optional.of(this._module), posses);
    }

    public ArrayList<Command.TabSuggestion> suggestNext(String args) {
        Equation equation = this._proof.getProofState().getTopEquation().getEquation();
        ArrayList<Command.TabSuggestion> ret = new ArrayList<Command.TabSuggestion>();
        if (args.equals("")) {
            ret.add(new Command.TabSuggestion("left", "keyword"));
            ret.add(new Command.TabSuggestion("right", "keyword"));
        }
        this.addCalculatablePositions(equation.getLhs(), EquationPosition.Side.Left, ret);
        this.addCalculatablePositions(equation.getRhs(), EquationPosition.Side.Right, ret);
        ret.add(this.endOfCommandSuggestion());
        return ret;
    }

    private void addCalculatablePositions(Term term, EquationPosition.Side side, ArrayList<Command.TabSuggestion> suggestions) {
        Printer printer = PrinterFactory.createParseablePrinter(this._proof.getContext().getTRS());
        term.visitSubterms((s, p) -> {
            if (s.isApplication() && s.isTheoryTerm() && s.isFirstOrder()) {
                EquationPosition pos = new EquationPosition(side, (Position)p);
                pos.print(printer);
                suggestions.add(new Command.TabSuggestion(printer.toString(), "position"));
                printer.clear();
            }
        });
    }
}

