/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.command;

import charlie.terms.Term;
import charlie.util.FixedList;
import cora.io.OutputModule;
import cora.rwinduction.command.Command;
import cora.rwinduction.command.DeductionCommand;
import cora.rwinduction.engine.deduction.DeductionCase;
import cora.rwinduction.parser.CommandParsingStatus;
import java.util.List;
import java.util.Optional;

public class CommandCase
extends DeductionCommand {
    @Override
    public String queryName() {
        return "case";
    }

    @Override
    public FixedList<String> callDescriptor() {
        return FixedList.of("calc <constraint>", "calc <integer expression>", "calc <variable>");
    }

    @Override
    public void printHelp(OutputModule module) {
        module.println("Use this deduction rule to split the current equation into one or more cases.", new Object[0]);
        module.startTable();
        module.nextColumn("*", new Object[0]);
        module.println("If you provide a constraint as argument, two new equations are created: one where the constraint holds, and one where it doesn't.", new Object[0]);
        module.nextColumn("*", new Object[0]);
        module.println("If you provide an integer expression, three equations are created: one with exp > 0, one with exp = 0 and one with exp < 0.", new Object[0]);
        module.nextColumn("*", new Object[0]);
        module.println("Finally, if you provide a variable of a non-theory base type, then an equation is created for all constructors that might instantiate this variable.", new Object[0]);
        module.endTable();
    }

    @Override
    protected DeductionCase createStep(CommandParsingStatus input) {
        if (this._proof.getProofState().isFinalState()) {
            this._module.println("There is no equation to do a case analysis on.", new Object[0]);
            return null;
        }
        if (input.commandEnded()) {
            this._module.println("Case should be invoked with at least one argument.", new Object[0]);
            return null;
        }
        Term term = input.readTerm(this._proof.getContext().getTRS(), this._proof.getProofState().getTopEquation().getRenaming(), this._module);
        if (term == null) {
            return null;
        }
        if (!input.commandEnded()) {
            this._module.println("Unexpected argument at position %a: expected end of command.", input.currentPosition());
            return null;
        }
        return DeductionCase.createStep(this._proof, Optional.of(this._module), term);
    }

    @Override
    public List<Command.TabSuggestion> suggestNext(String args) {
        return List.of(new Command.TabSuggestion(null, "constraint, integer expression or variable"));
    }
}

