/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.command;

import charlie.printer.Printer;
import charlie.trs.IllegalRuleException;
import charlie.trs.Rule;
import charlie.trs.TRS;
import charlie.trs.TrsFactory;
import charlie.util.FixedList;
import cora.io.OutputModule;
import cora.io.ProofObject;
import cora.rwinduction.command.Command;
import cora.rwinduction.engine.OrdReq;
import cora.rwinduction.parser.CommandParsingStatus;
import cora.termination.TerminationHandler;
import java.util.ArrayList;

public class CommandCheck
extends Command {
    @Override
    public String queryName() {
        return ":check";
    }

    @Override
    public FixedList<String> callDescriptor() {
        return FixedList.of(":check", ":check brief", ":check verbose");
    }

    @Override
    public void printHelp(OutputModule module) {
        module.println("Checks if the ordering requirements so far are satisfied.  This is not complete: there may be false negatives.  But if this answers that the requirements are satisfiable, they are.", new Object[0]);
        module.println("The verbosity parameter indicates whether the full proof should be printed.  By default, it is not.", new Object[0]);
    }

    public ArrayList<Command.TabSuggestion> suggestNext(String args) {
        ArrayList<Command.TabSuggestion> ret = new ArrayList<Command.TabSuggestion>();
        ret.add(this.endOfCommandSuggestion());
        if (!args.equals("")) {
            return ret;
        }
        ret.add(new Command.TabSuggestion("brief", "keyword"));
        ret.add(new Command.TabSuggestion("verbose", "keyword"));
        return ret;
    }

    @Override
    protected boolean run(CommandParsingStatus input) {
        int brevity;
        String txt = input.nextWord();
        if (txt == null || txt.equals("")) {
            brevity = 1;
        } else if (txt.equals("brief")) {
            brevity = 0;
        } else if (txt.equals("verbose")) {
            brevity = 2;
        } else {
            this._module.println("Illegal argument: %a", txt);
            return false;
        }
        if (!input.commandEnded()) {
            this._module.println("Unexpected argument at position %a: :check takes at most 1 argument.", input.currentPosition());
            return false;
        }
        if (brevity > 0) {
            this._module.println("Sending proof request to termination checker...", new Object[0]);
        }
        ProofObject po = this.createTerminationProof();
        switch (po.queryAnswer()) {
            case YES: {
                this._module.println("The current set of ordering requirements is indeed orientable.", new Object[0]);
                if (!this._proof.isFinal()) break;
                this._proof.finish(po);
                break;
            }
            default: {
                this._module.println("Failed to find a proof that the current set of ordering requirements is orientable.  You may need to use a more sophisticated approach.", new Object[0]);
            }
        }
        if (brevity >= 2) {
            po.justify(this._module);
        }
        return true;
    }

    private ProofObject createTerminationProof() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (Rule rule : this._proof.getContext().getTRS().queryRules()) {
            rules.add(rule);
        }
        for (final OrdReq req : this._proof.getProofState().getOrderingRequirements()) {
            try {
                rules.add(this.makeRule(req));
            }
            catch (IllegalRuleException e) {
                return new ProofObject(){

                    @Override
                    public ProofObject.Answer queryAnswer() {
                        return ProofObject.Answer.MAYBE;
                    }

                    @Override
                    public void justify(OutputModule out) {
                        out.println("Failed to transform ordering requirement %a into a rule: %a.", req, Printer.makePrintable(e, req.queryRenaming()));
                    }
                };
            }
        }
        TRS trs = this._proof.getContext().getTRS().createDerivative(rules);
        return TerminationHandler.proveTermination(trs);
    }

    private Rule makeRule(OrdReq req) {
        return TrsFactory.createRule(req.getLhs(), req.getRhs(), req.getConstraint());
    }
}

