/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.command;

import charlie.printer.Printer;
import charlie.printer.PrinterFactory;
import charlie.terms.Term;
import charlie.terms.position.Position;
import charlie.terms.position.PositionFormatException;
import charlie.util.FixedList;
import charlie.util.Pair;
import cora.io.OutputModule;
import cora.rwinduction.command.Command;
import cora.rwinduction.command.DeductionCommand;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.deduction.DeductionContext;
import cora.rwinduction.parser.CommandParsingStatus;
import java.util.ArrayList;
import java.util.HashSet;

public class CommandContext
extends DeductionCommand {
    @Override
    public String queryName() {
        return "context";
    }

    @Override
    public FixedList<String> callDescriptor() {
        return FixedList.of("context", "context <position_1> ... <position_n>", "context safe");
    }

    @Override
    public void printHelp(OutputModule module) {
        module.println("Use this deduction rule without any arguments to split an equation f s1 ... sn = f t1 ... tn | constr into the n equations si = ti | constr, regardless of whether f is a function symbol or variable.", new Object[0]);
        module.println("Use the deduction rule with position arguments to split an equation C[s1,...,sn] = C[t1,...,tn] | constr into the n equations si = ti | constr, where the arguments indicate the positions of the subterms si/ti.", new Object[0]);
        module.println("Using this command typically loses completeness of the proof state, although completeness is preserved automatically if possible.  If you wish to be sure that completeness is preserved, use semiconstructor (perhaps combined with deletion) instead, or use the final syntax of the context command: giving the argument \"safe\" chooses a maximal semi-constructor context, which will preserve completeness.", new Object[0]);
    }

    @Override
    protected DeductionContext createStep(CommandParsingStatus input) {
        ArrayList<Position> posses = this.readPositions(input);
        if (posses == null) {
            return null;
        }
        if (posses.isEmpty()) {
            return DeductionContext.createStep(this._proof, this.optionalModule(), false);
        }
        return DeductionContext.createStep(this._proof, this.optionalModule(), posses);
    }

    private ArrayList<Position> readPositions(CommandParsingStatus input) {
        ArrayList<Position> posses = new ArrayList<Position>();
        String word = input.nextWord();
        if (word != null && word.equals("safe")) {
            if (!input.commandEnded()) {
                this._module.println("Unexpected argument at positin %a: expected end of command.", input.currentPosition());
                return null;
            }
            return this.safePositions();
        }
        while (word != null) {
            try {
                posses.add(Position.parse(word));
            }
            catch (PositionFormatException e) {
                this._module.println("Illegal position %a (character %a): %a", word, e.queryProblemPos(), e.queryExplanation());
                return null;
            }
            word = input.nextWord();
        }
        return posses;
    }

    private ArrayList<Position> safePositions() {
        EquationContext ec = this._proof.getProofState().getTopEquation();
        ArrayList<Position> posses = new ArrayList<Position>();
        DeductionContext.storeDifferences(ec.getLhs(), ec.getRhs(), this._proof.getContext(), posses, new ArrayList<Pair<Term, Term>>());
        if (posses.size() == 0) {
            this._module.println("Both sides are the same; please use DELETE instead.", new Object[0]);
            return null;
        }
        if (posses.size() == 1 && posses.get(0).isEmpty()) {
            this._module.println("No SEMICONSTRUCTOR step can be applied.", new Object[0]);
            return null;
        }
        return posses;
    }

    public ArrayList<Command.TabSuggestion> suggestNext(String args) {
        ArrayList<Command.TabSuggestion> ret = new ArrayList<Command.TabSuggestion>();
        ret.add(this.endOfCommandSuggestion());
        if (args.equals("")) {
            ret.add(new Command.TabSuggestion("safe", "keyword"));
        } else if (args.equals("safe")) {
            return ret;
        }
        HashSet<Position> given = this.readPositionsInText(args.split(" "));
        Term lhs = this._proof.getProofState().getTopEquation().getLhs();
        Term rhs = this._proof.getProofState().getTopEquation().getRhs();
        Printer printer = PrinterFactory.createParseablePrinter(this._proof.getContext().getTRS());
        for (Position p : lhs.queryPositions(false)) {
            if (p.isEmpty() || given.contains(p) || !this.samePath(lhs, rhs, p)) continue;
            printer.add(p);
            ret.add(new Command.TabSuggestion(printer.toString(), "position"));
            printer.clear();
        }
        return ret;
    }

    private HashSet<Position> readPositionsInText(String[] text) {
        HashSet<Position> ret = new HashSet<Position>();
        for (String word : text) {
            try {
                ret.add(Position.parse(word));
            }
            catch (PositionFormatException positionFormatException) {
                // empty catch block
            }
        }
        return ret;
    }

    private boolean samePath(Term s, Term t, Position p) {
        if (p.isFinal()) {
            return true;
        }
        if (!s.queryHead().equals(t.queryHead())) {
            return false;
        }
        int k = p.queryHead();
        if (k <= 0 || k > s.numberArguments() || k > t.numberArguments()) {
            return false;
        }
        return this.samePath(s.queryArgument(k), t.queryArgument(k), p.queryTail());
    }
}

