/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.command;

import charlie.substitution.MutableSubstitution;
import charlie.terms.Term;
import charlie.terms.replaceable.MutableRenaming;
import charlie.terms.replaceable.Renaming;
import charlie.terms.replaceable.Replaceable;
import charlie.util.FixedList;
import charlie.util.Pair;
import cora.io.OutputModule;
import cora.rwinduction.command.Command;
import cora.rwinduction.command.DeductionCommand;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.automation.AutoDisprover;
import cora.rwinduction.engine.deduction.DeductionDisproveRoot;
import cora.rwinduction.engine.deduction.DeductionDisproveTheory;
import cora.rwinduction.parser.CommandParsingStatus;
import java.util.ArrayList;
import java.util.Set;

public class CommandDisprove
extends DeductionCommand {
    @Override
    public String queryName() {
        return "disprove";
    }

    @Override
    public FixedList<String> callDescriptor() {
        return FixedList.of("disprove", "disprove root", "disprove theory", "disprove theory with <substitution>");
    }

    @Override
    public void printHelp(OutputModule module) {
        module.println("Use this deduction rule to derive a contradiction: the initial set of equations contains one that is NOT an inductive theorem.", new Object[0]);
    }

    public ArrayList<Command.TabSuggestion> suggestNext(String args) {
        ArrayList<Command.TabSuggestion> ret = new ArrayList<Command.TabSuggestion>();
        String[] parts = args.strip().split("\\s+");
        if (parts.length == 0 || parts[0].equals("")) {
            this.addNoArgumentsSuggestions(ret);
        } else if (parts.length == 1) {
            if (parts[0].equals("root")) {
                ret.add(this.endOfCommandSuggestion());
            }
            if (parts[0].equals("theory")) {
                ret.add(this.endOfCommandSuggestion());
                ret.add(new Command.TabSuggestion("with", "keyword"));
            }
        } else if (parts[1].equals("with")) {
            this.addSubstitutionSuggestions(parts[parts.length - 1], ret);
        }
        return ret;
    }

    private void addNoArgumentsSuggestions(ArrayList<Command.TabSuggestion> ret) {
        ret.add(this.endOfCommandSuggestion());
        if (this._proof.getProofState().getTopEquation().getLhs().isTheoryTerm() && this._proof.getProofState().getTopEquation().getRhs().isTheoryTerm() && this._proof.getProofState().getTopEquation().getLhs().queryType().isBaseType()) {
            ret.add(new Command.TabSuggestion("theory", "keyword"));
        } else {
            ret.add(new Command.TabSuggestion("root", "keyword"));
        }
    }

    private void addSubstitutionSuggestions(String lastWord, ArrayList<Command.TabSuggestion> ret) {
        if (!lastWord.equals("") && lastWord.charAt(lastWord.length() - 1) == ']') {
            ret.add(this.endOfCommandSuggestion());
        } else {
            ret.add(new Command.TabSuggestion(null, "substitution"));
        }
    }

    @Override
    protected DeductionStep createStep(CommandParsingStatus input) {
        if (input.commandEnded()) {
            return AutoDisprover.createStep(this._proof, this.optionalModule());
        }
        String word = input.nextWord();
        if (word.equals("root")) {
            return this.createRootStep(input);
        }
        if (word.equals("theory")) {
            return this.createTheoryStep(input);
        }
        this._module.println("Unexpected argument at position %a: expected \"root\" or \"theory\" (or end of command).", input.previousPosition());
        return null;
    }

    private DeductionDisproveRoot createRootStep(CommandParsingStatus input) {
        if (!input.commandEnded()) {
            this._module.println("Unexpected argument at position %a: disprove root command should end after the \"root\".", input.currentPosition());
            return null;
        }
        return DeductionDisproveRoot.createStep(this._proof, this.optionalModule());
    }

    private DeductionStep createTheoryStep(CommandParsingStatus input) {
        if (input.commandEnded()) {
            return AutoDisprover.createTheoryStep(this._proof, this.optionalModule());
        }
        if (!input.expect("with", this.optionalModule())) {
            return null;
        }
        if (this._proof.getProofState().isFinalState()) {
            this._module.println("The proof state is empty; there is nothing to disprove.", new Object[0]);
            return null;
        }
        Renaming keyNames = this._proof.getProofState().getTopEquation().getRenaming();
        MutableRenaming valueNames = new MutableRenaming(Set.of());
        MutableSubstitution subst = input.readSubstitution(this._proof.getContext().getTRS(), keyNames, valueNames, this._module);
        if (subst == null) {
            return null;
        }
        for (Replaceable x : keyNames.domain()) {
            Term result = subst.get(x);
            if (result == null) {
                this._module.println("The substitution should map ALL variables of the equation; missing %a.", keyNames.getName(x));
                return null;
            }
            if (subst.get(x).isGround() && subst.get(x).isTheoryTerm()) continue;
            this._module.println("Illegal mapping [%a := %a]: the substitution should map to ground theory terms.", keyNames.getName(x), new Pair<Term, MutableRenaming>(subst.get(x), valueNames));
            return null;
        }
        return DeductionDisproveTheory.createStep(this._proof, this.optionalModule(), subst);
    }
}

