/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.command;

import charlie.util.FixedList;
import cora.io.OutputModule;
import cora.rwinduction.command.Command;
import cora.rwinduction.engine.EquationContext;
import cora.rwinduction.engine.ProofState;
import cora.rwinduction.parser.CommandParsingStatus;
import java.util.List;

public class CommandEquations
extends Command {
    @Override
    public String queryName() {
        return ":equations";
    }

    @Override
    public FixedList<String> callDescriptor() {
        return FixedList.of(":equations", ":equations full");
    }

    @Override
    public void printHelp(OutputModule module) {
        module.println("List all the currently open equations (goals that we still need to prove).", new Object[0]);
        module.println("If you want to see the full equation context, use the \"full\" argument.", new Object[0]);
    }

    @Override
    public List<Command.TabSuggestion> suggestNext(String args) {
        if (!args.equals("")) {
            return List.of(this.endOfCommandSuggestion());
        }
        return List.of(this.endOfCommandSuggestion(), new Command.TabSuggestion("full", "keyword"));
    }

    @Override
    protected boolean run(CommandParsingStatus input) {
        if (input.commandEnded()) {
            this.printEquations(false);
            return true;
        }
        if (input.nextWord().equals("full")) {
            this.printEquations(true);
            return true;
        }
        this._module.println("Unexpected argument at position %a: :equations takes either no arguments, or only the argument \"full\".", input.previousPosition());
        return false;
    }

    private void printEquations(boolean full) {
        ProofState state = this._proof.getProofState();
        this._module.startTable();
        for (EquationContext ec : state.getEquations()) {
            if (full) {
                this._module.println("%a", ec);
                continue;
            }
            this._module.nextColumn("%a:", ec.getName());
            this._module.nextColumn("%a", ec.getEquation().makePrintableWith(ec.getRenaming()));
            if (state.getIncompleteEquations().contains(ec.getIndex())) {
                this._module.println("(INCOMPLETE)", new Object[0]);
                continue;
            }
            this._module.println();
        }
        this._module.endTable();
    }
}

