/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.command;

import charlie.terms.Term;
import charlie.terms.replaceable.Renaming;
import charlie.util.FixedList;
import cora.io.OutputModule;
import cora.rwinduction.command.Command;
import cora.rwinduction.command.DeductionCommand;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.deduction.DeductionAlterGeneraliseConstraint;
import cora.rwinduction.engine.deduction.DeductionGeneraliseDrop;
import cora.rwinduction.engine.deduction.DeductionGeneraliseSubterm;
import cora.rwinduction.parser.CommandParsingStatus;
import java.util.ArrayList;
import java.util.Optional;

public class CommandGeneralise
extends DeductionCommand {
    @Override
    public String queryName() {
        return "generalise";
    }

    @Override
    public FixedList<String> callDescriptor() {
        return FixedList.of("generalise subterm <term> as <variable>", "generalise drop <constraint>", "generalise constraint <constraint>");
    }

    @Override
    public void printHelp(OutputModule module) {
        module.println("Use this deduction rule to replace an equation by a more general one.  This causes completeness to be lost.  Currently, there are three supported ways of generalising:", new Object[0]);
        module.startTable();
        module.nextColumn("*", new Object[0]);
        module.println("Replacing all instances of a specific subterm by a variable.  If the current bounding terms are not the top element, then most likely, they will be tightened to the corresponding side of the equation.", new Object[0]);
        module.nextColumn("*", new Object[0]);
        module.println("Dropping a part of the constraint.  If the constraint currently has a form part1 %{and} ... %{and} partn, you can supply parti or some conjunction of parti elements which are then removed from the constraint.  This does not cause the bounding terms to be changed, and does not require an invocation of the SMT-solver.", new Object[0]);
        module.nextColumn("*", new Object[0]);
        module.println("Generalising the constraint to an implied one.  This does require an invocation of the SMT-solver to ensure that the new constraint you supply is indeed implied.  Note that the new constraint may not have any variables that do not occur in the original one.", new Object[0]);
        module.endTable();
    }

    @Override
    protected DeductionStep createStep(CommandParsingStatus input) {
        String action = input.nextWord();
        if (input.commandEnded()) {
            this._module.println("Generalise should be invoked with at least two arguments.", new Object[0]);
            return null;
        }
        Renaming renaming = this._proof.getProofState().getTopEquation().getRenaming();
        Term term = input.readTerm(this._proof.getContext().getTRS(), renaming, this._module);
        if (term == null) {
            return null;
        }
        if (action.equals("subterm")) {
            return this.createSubtermStep(input, term);
        }
        if (action.equals("drop")) {
            return this.createDropStep(input, term);
        }
        if (action.equals("constraint")) {
            return this.createConstraintStep(input, term);
        }
        this._module.println("Unknown action for alter: %a.", action);
        return null;
    }

    DeductionGeneraliseSubterm createSubtermStep(CommandParsingStatus input, Term subterm) {
        Optional<OutputModule> om = Optional.of(this._module);
        if (!input.expect("as", om)) {
            return null;
        }
        String name = input.nextWord();
        if (name == null) {
            this._module.println("Missing variable name at position %a.", input.currentPosition());
            return null;
        }
        if (!input.commandEnded()) {
            this._module.println("Unexpected argument at position %a: generalise subterm command should end after the variable name.", input.currentPosition());
            return null;
        }
        return DeductionGeneraliseSubterm.createStep(this._proof, om, subterm, name);
    }

    DeductionGeneraliseDrop createDropStep(CommandParsingStatus input, Term drop) {
        if (!input.commandEnded()) {
            this._module.println("Unexpected argument at position %a: expected end of command.", input.currentPosition());
            return null;
        }
        return DeductionGeneraliseDrop.createStep(this._proof, Optional.of(this._module), drop);
    }

    DeductionAlterGeneraliseConstraint createConstraintStep(CommandParsingStatus input, Term c) {
        if (!input.commandEnded()) {
            this._module.println("Unexpected argument at position %a: expected end of command.", input.currentPosition());
            return null;
        }
        return DeductionAlterGeneraliseConstraint.createGeneraliseStep(this._proof, Optional.of(this._module), c);
    }

    public ArrayList<Command.TabSuggestion> suggestNext(String args) {
        ArrayList<Command.TabSuggestion> ret = new ArrayList<Command.TabSuggestion>();
        CommandParsingStatus status = new CommandParsingStatus(args);
        if (status.commandEnded()) {
            ret.add(new Command.TabSuggestion("subterm", "keyword"));
            ret.add(new Command.TabSuggestion("drop", "keyword"));
            ret.add(new Command.TabSuggestion("constraint", "keyword"));
            return ret;
        }
        String w = status.nextWord();
        if (w.equals("subterm")) {
            this.addSubtermSuggestions(status, ret);
        } else {
            this.addConstraintSuggestions(status, ret);
        }
        return ret;
    }

    private void addSubtermSuggestions(CommandParsingStatus status, ArrayList<Command.TabSuggestion> ret) {
        if (status.commandEnded() || !status.skipTerm()) {
            ret.add(new Command.TabSuggestion(null, "term"));
        } else if (status.commandEnded()) {
            ret.add(new Command.TabSuggestion("as", "keyword"));
        } else if (status.nextWord().equals("as") && status.commandEnded()) {
            ret.add(new Command.TabSuggestion(null, "variable name"));
        } else {
            ret.add(this.endOfCommandSuggestion());
        }
    }

    private void addConstraintSuggestions(CommandParsingStatus status, ArrayList<Command.TabSuggestion> ret) {
        if (status.commandEnded()) {
            ret.add(new Command.TabSuggestion(null, "constraint"));
        } else {
            ret.add(new Command.TabSuggestion(null, "rest of constraint"));
            if (status.skipTerm() && status.commandEnded()) {
                ret.add(this.endOfCommandSuggestion());
            }
        }
    }
}

