/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.command;

import charlie.substitution.Substitution;
import charlie.terms.replaceable.Renaming;
import charlie.util.Pair;
import cora.io.OutputModule;
import cora.rwinduction.command.HypothesisCommandInherit;
import cora.rwinduction.engine.DeductionStep;
import cora.rwinduction.engine.EquationPosition;
import cora.rwinduction.engine.Hypothesis;
import cora.rwinduction.engine.automation.AutoDeleter;
import cora.rwinduction.engine.deduction.DeductionHdelete;
import cora.rwinduction.parser.CommandParsingStatus;
import java.util.Optional;

public class CommandHdelete
extends HypothesisCommandInherit {
    public CommandHdelete() {
        super("hdelete");
    }

    @Override
    public void printHelp(OutputModule module) {
        module.println("Use this deduction rule to rewrite one side of the current equation to the other side, using one of the current induction hypotheses in the proof state.", new Object[0]);
        module.println("Note that induction hypotheses can be found using :hypotheses, and that positions have the form L.%{langle}position%{rangle} or R.%{langle}position%{rangle}.", new Object[0]);
        module.println("To use the inverse of an induction hypothesis, use for instance H5^{-1} or H5-inverse.  (Or just apply the deduction rule on the other side!)", new Object[0]);
    }

    @Override
    protected DeductionStep createStep(CommandParsingStatus input) {
        if (input.commandEnded()) {
            return AutoDeleter.createHdeleteStep(this._proof, Optional.of(this._module));
        }
        Pair<Hypothesis, Boolean> hypopair = this.readHypothesis(input);
        if (hypopair == null) {
            return null;
        }
        Renaming hypoRenaming = hypopair.fst().getRenaming();
        Pair<EquationPosition, Substitution> restpair = this.readCommandRemainder(hypoRenaming, input);
        if (restpair == null) {
            return null;
        }
        return DeductionHdelete.createStep(this._proof, Optional.of(this._module), hypopair.fst(), hypopair.snd(), restpair.fst(), restpair.snd());
    }
}

