/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.command;

import charlie.util.FixedList;
import cora.io.OutputModule;
import cora.rwinduction.command.CmdList;
import cora.rwinduction.command.Command;
import cora.rwinduction.parser.CommandParsingStatus;
import java.util.ArrayList;

public class CommandHelp
extends Command {
    private CmdList _clist;

    public CommandHelp(CmdList lst) {
        this._clist = lst;
    }

    @Override
    public String queryName() {
        return ":help";
    }

    @Override
    public FixedList<String> callDescriptor() {
        return FixedList.of(":help", ":help commands", ":help <command>");
    }

    @Override
    public void printHelp(OutputModule module) {
        module.println("Prints a short description to explain how the prover works.", new Object[0]);
    }

    public ArrayList<Command.TabSuggestion> suggestNext(String args) {
        ArrayList<Command.TabSuggestion> ret = new ArrayList<Command.TabSuggestion>();
        ret.add(this.endOfCommandSuggestion());
        if (!args.equals("")) {
            return ret;
        }
        ret.add(new Command.TabSuggestion("commands", "keyword"));
        for (String name : this._clist.queryCommands()) {
            ret.add(new Command.TabSuggestion(name, "command"));
        }
        return ret;
    }

    @Override
    protected boolean run(CommandParsingStatus input) {
        if (input.commandEnded()) {
            return this.printGeneralHelp();
        }
        String txt = input.nextWord();
        if (!input.commandEnded()) {
            this._module.println("Unexpected argument at position %a: :help takes at most 1 argument.", input.currentPosition());
            return false;
        }
        if (txt.equals("commands")) {
            return this.printCommandList();
        }
        Command cmd = this._clist.queryCommand(txt);
        if (cmd == null) {
            return this.failure("Unknown command: " + txt);
        }
        return this.printCommandHelp(cmd);
    }

    private boolean printGeneralHelp() {
        this._module.println("Welcome to the interactive equivalence prover!", new Object[0]);
        this._module.startTable();
        this._module.println("To list available commands, use: :help commands", new Object[0]);
        this._module.println("To get out of the prover, use    :quit", new Object[0]);
        this._module.endTable();
        return true;
    }

    private boolean printCommandList() {
        this._module.println("You can use the following commands to interact with the prover:", new Object[0]);
        StringBuilder envcmds = new StringBuilder();
        StringBuilder deducmds = new StringBuilder();
        for (String str : this._clist.queryCommands()) {
            if (str.charAt(0) == ':') {
                envcmds.append(str + " ");
                continue;
            }
            deducmds.append(str + " ");
        }
        this._module.startTable();
        this._module.println("Prover commands: %a", envcmds.toString());
        this._module.println("Deduction rules: %a", deducmds.toString());
        this._module.endTable();
        return true;
    }

    private boolean printCommandHelp(Command cmd) {
        cmd.printHelp(this._module);
        this._module.startTable();
        for (String str : cmd.callDescriptor()) {
            this._module.println("%a", str);
        }
        this._module.endTable();
        return true;
    }
}

