/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.command;

import cora.io.OutputModule;
import cora.rwinduction.command.SingularCommandInherit;
import cora.rwinduction.engine.Hypothesis;
import cora.rwinduction.engine.ProofState;

public class CommandHypotheses
extends SingularCommandInherit {
    @Override
    public String queryName() {
        return ":hypotheses";
    }

    @Override
    public void printHelp(OutputModule module) {
        module.println("List all the currently available induction hypotheses.", new Object[0]);
    }

    @Override
    protected boolean run() {
        ProofState state = this._proof.getProofState();
        if (state.getHypotheses().size() == 0) {
            this._module.println("There are currently no induction hypotheses.", new Object[0]);
        } else {
            this._module.println("You currently have the following induction hypotheses available:", new Object[0]);
            this._module.startTable();
            for (Hypothesis hypo : state.getHypotheses()) {
                this._module.println("%a", hypo);
            }
            this._module.endTable();
        }
        return true;
    }
}

