/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.command;

import charlie.substitution.Substitution;
import charlie.terms.replaceable.Renaming;
import charlie.util.Pair;
import cora.io.OutputModule;
import cora.rwinduction.command.HypothesisCommandInherit;
import cora.rwinduction.engine.EquationPosition;
import cora.rwinduction.engine.Hypothesis;
import cora.rwinduction.engine.automation.AutoHypothesis;
import cora.rwinduction.engine.deduction.DeductionHypothesis;
import cora.rwinduction.parser.CommandParsingStatus;
import java.util.Optional;

public class CommandHypothesis
extends HypothesisCommandInherit {
    public CommandHypothesis() {
        super("hypothesis");
    }

    @Override
    public void printHelp(OutputModule module) {
        module.println("Use this deduction rule to rewrite the current equation with one of the current induction hypotheses in the proof state, which might apply to some subterm of the left- or right-hand side of the equation.", new Object[0]);
        module.println("Note that induction hypotheses can be found using :hypotheses, and that positions have the form L.<position> or R.<position>.", new Object[0]);
        module.println("To use the inverse of an induction hypothesis, use for instance H5^{-1} or H5-inverse.", new Object[0]);
    }

    @Override
    protected DeductionHypothesis createStep(CommandParsingStatus input) {
        if (input.commandEnded()) {
            return AutoHypothesis.createHypothesisStep(this._proof, this._module);
        }
        Pair<Hypothesis, Boolean> hypopair = this.readHypothesis(input);
        if (hypopair == null) {
            return null;
        }
        Renaming hypoRenaming = hypopair.fst().getRenaming();
        Pair<EquationPosition, Substitution> restpair = this.readCommandRemainder(hypoRenaming, input);
        if (restpair == null) {
            return null;
        }
        return DeductionHypothesis.createStep(this._proof, Optional.of(this._module), hypopair.fst(), hypopair.snd(), restpair.fst(), restpair.snd());
    }
}

