/*
 * Decompiled with CFR 0.152.
 */
package cora.rwinduction.command;

import cora.io.OutputModule;
import cora.rwinduction.command.SingularCommandInherit;
import cora.rwinduction.engine.OrdReq;
import cora.rwinduction.engine.ProofState;

public class CommandOrdering
extends SingularCommandInherit {
    @Override
    public String queryName() {
        return ":ordering";
    }

    @Override
    public void printHelp(OutputModule module) {
        module.println("List all the ordering requirements that have so far been imposed.", new Object[0]);
    }

    @Override
    protected boolean run() {
        ProofState state = this._proof.getProofState();
        if (state.getOrderingRequirements().size() == 0) {
            this._module.println("No ordering requirements have been imposed so far.", new Object[0]);
        } else {
            this._module.println("So far the following ordering requirements have been imposed:", new Object[0]);
            this._module.startTable();
            for (OrdReq req : state.getOrderingRequirements()) {
                this._module.println("%a", req);
            }
            this._module.endTable();
        }
        return true;
    }
}

